/************************************************************************
 * FILE:         fc_tclSTC_PDD
 * PROJECT:      PSA-RCC
 * SW-COMPONENT: Fc_STC
 *----------------------------------------------------------------------
 *
 * DESCRIPTION: This file contains the implementation of PDD class used in Fc_STC component
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author		                   		  		| Modification
 * 01.01.17  | RBEI/ECP4 ARJUN KUMAR R L     | initial version
 *************************************************************************/
#include "../include/fc_tclSTC_PDD.h"

#include "dlt/dlt.h"

DLT_DECLARE_CONTEXT(STC_PDD)

fc_tclSTC_PDD* fc_tclSTC_PDD::m_pofc_tclSTC_PDD = NULL;

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:    fc_tclSTC_PDD::fc_tclSTC_PDD()
 *
 *DESCRIPTION:  constructior
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 ******************************************************************-FUNCHEADER*/

fc_tclSTC_PDD::fc_tclSTC_PDD()
{
	DLT_REGISTER_CONTEXT(STC_PDD,"PDD0","Registration of FCSTC PDD");
	//ETG_TRACE_USR4(("fc_tclConnect_PDD() Constructor"));
	//cout<<"fc_tclConnect_PDD() Constructor "<<endl;
	m_pofc_tclSTC_PDD = this;
	m_CPTtime = 0;
	m_SECURETime = 0;
	m_buildTime = 0;
	m_dp_tclFC_STCDPSECURE_TIME.s32GetData(m_SECURETime);
	m_dp_tclFC_STCDPCPT_TEMPOREL_TIME.s32GetData(m_CPTtime);
	//cout<<"before reading file m_SECURETime = "<<m_SECURETime<<endl;
	//cout<<" m_CPTtime = "<<m_CPTtime<<endl;

	DLT_LOG(STC_PDD, DLT_LOG_INFO,DLT_STRING("[INFO] LastPDD SecureTime: "),DLT_UINT64(m_SECURETime));
	DLT_LOG(STC_PDD, DLT_LOG_INFO,DLT_STRING("[INFO]LastPDD CPT value: "),DLT_UINT64(m_CPTtime));
	
	vGetBuiltime();
	//cout<<"After reading m_SECURETime = "<<m_SECURETime<<endl;
	//cout<<"m_CPTtime = "<<m_CPTtime<<endl;


}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:    fc_tclSTC_PDD::~fc_tclSTC_PDD()
 *
 *DESCRIPTION:  destructor
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 ******************************************************************-FUNCHEADER*/

fc_tclSTC_PDD::~fc_tclSTC_PDD()
{
	DLT_UNREGISTER_CONTEXT(STC_PDD);
	//ETG_TRACE_USR4(("~fc_tclConnect_PDD Destructor"));
	if(m_pofc_tclSTC_PDD)
	{
		delete m_pofc_tclSTC_PDD;
		m_pofc_tclSTC_PDD = NULL;
	}
}
/********************************************************************
 *
 *FUNCTION:     m_poGetm_pofc_tclSTC_PDDInstance()
 *
 *DESCRIPTION:  Function to return the object of this class
 *
 *PARAMETER:    none
 *
 *RETURNVALUE:  fc_tclSTC_PDD *
 *
 *******************************************************************/
fc_tclSTC_PDD * fc_tclSTC_PDD::m_poGetm_pofc_tclSTC_PDDInstance()
{
	//ETG_TRACE_USR4(("fc_tclConnect_PDD::m_poGetfc_tclConnect_PDDInstance m_pofc_tclConnect_PDD = %d",m_pofc_tclConnect_PDD ));
	return m_pofc_tclSTC_PDD;
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:    fc_tclSTC_PDD::ReturnLastSavedCANtime()
 *
 *DESCRIPTION:  To return last saved CAN date and time.
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  unsigned long
 *
 ******************************************************************-FUNCHEADER*/

tU64 fc_tclSTC_PDD::ReturnLastSavedCPTtime()
{
    //cout<<"ReturnLastSavedCPTtime::m_CPTtime = "<<m_CPTtime<<endl;
	return m_CPTtime;
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:    fc_tclSTC_PDD::ReturnLastSavedSecuretime()
 *
 *DESCRIPTION:  To return last saved SYSTEM date and time.
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  unsigned long
 *
 ******************************************************************-FUNCHEADER*/

tU64 fc_tclSTC_PDD::ReturnLastSavedSecuretime()
{
    //cout<<"ReturnLastSavedSecuretime::m_SECURETime = "<<m_SECURETime<<endl;
	return m_SECURETime;
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:    fc_tclSTC_PDD::vGetBuiltime()
 *
 *DESCRIPTION:  To read buid time.
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  None
 *
 ******************************************************************-FUNCHEADER*/
void fc_tclSTC_PDD::vGetBuiltime()
{	
	//cout<<"fc_tclSTC_CSMCallbackHandler::vGetBuiltime()"<<endl;
	string line;  
    string strNew; 
	ifstream infile;    
	infile.open(SW_VERSION_DATE);   
	tU32 date = 160101;
	//cout<<"date = "<<date<<endl;
	tU32 year = 16;
	tU32 month = 1;
	tU32 day = 1;
	if(infile.fail())
	{
		//cout << "ERROR.\n"<<endl;
	}
	else
	{
		while(!infile.eof())
		{
			getline(infile,line); 
			//cout<<line + "\n"; 
			if(line.find("_")!= string::npos)
			{
				unsigned first = line.find("_");
				strNew = line.substr (first+1,6);
				//cout<<"strNew = "<<strNew<<endl;
				date = atoi(strNew.c_str());
				year = date/10000;
				month = date - (year*10000);
				month = month/100;
				day = date % 100;
				break;
			}
		}   
		infile.close(); 
	}
	//cout<<"date = "<<date<<endl;

	//cout<<"year = "<<year<<endl;

	//cout<<"month = "<<month<<endl;

	//cout<<"day = "<<day<<endl;
	year = 2000 + year;
	if((year >2015) && (year < 2038))
	{
		//cout<<"(year >2016) && (year < 2038) "<<endl;
		struct tm tm_info;
		tm_info.tm_year = year - 1900;
		tm_info.tm_mon  = month - 1;
		tm_info.tm_mday = day;
		tm_info.tm_hour = 0;
		tm_info.tm_min  = 0;
		tm_info.tm_sec  = 0;
		tm_info.tm_isdst= 0;
		time_t raw_format  = mktime(&tm_info);
		//cout<<"month = "<<month<<endl;
		tU32 build = (tU32)raw_format;
		m_buildTime = (tU64)build;
	
		//cout<<"raw_format = "<<raw_format<<endl;
		//cout<<"build = "<<build<<endl;
		//cout<<"m_buildTime = "<<m_buildTime<<endl;
	}
	else if((year >2037) && (year < 2125))
    {
		//cout<<"(year >2037) && (year < 2125) "<<endl;
    	tU16 arrmonth[12] = {31,59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    	tU64 i, leap_days = 17, number_days = 0;
		tU64 seconds = 0;

    	for(i=2037; i<year; i++) //time set to connman is from epoch
    	{
    		if(CHECK_LEAP_YEAR(i))
    		{
    			leap_days++;
    		}
    	}
    	//cout <<"number of days initial " <<number_days<<endl;
    	//cout<<"leap day is"<<leap_days <<endl;
    	number_days = (365*(year - 1970)) + leap_days;
    	//cout<<"total number of days in years from 1970 is" <<number_days <<endl;

    	/************************** month ************************************/
    	if((month >1)) //count only if not January
    	{
    		number_days = number_days + arrmonth[month-2];
    		if((month >2) && (CHECK_LEAP_YEAR(year))) //month is greater than feb and is a leap year add another day
    			number_days = number_days + 1;
    		//cout<<"total number of days in years plus months from 1970 is" <<number_days <<endl;
    	}
    	number_days = number_days + (day - 1);

    	seconds = (number_days * 24 * 3600); // no hour,min and seconds int * int = int i.e why tU64
    	//cout<<"seconds = "<<seconds<<endl;
		m_buildTime = seconds;
    }
	if(m_SECURETime < m_buildTime) //If read value is less build time --> update to build time
	{
		//cout<<"m_SECURETime = "<<m_SECURETime<<endl;
		m_SECURETime = m_buildTime;
		//cout<<"m_SECURETime = "<<m_SECURETime<<endl;
		DLT_LOG(STC_PDD, DLT_LOG_INFO,DLT_STRING("[INFO]  Set To built time SecureTime : "),DLT_UINT64(m_SECURETime));
	}

}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:    fc_tclSTC_PDD::vSaveCANandSYSTEMdate()
 *
 *DESCRIPTION:  To return last saved SYSTEM date and time.
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  SYSTEMDateAndTimeStruct
 *
 ******************************************************************-FUNCHEADER*/

void fc_tclSTC_PDD::vSaveCPTandSECUREtime(tU64 SECUREShutdown, tU64 CPTShutdown)
{
	//cout<<"Saving SECUREShutdown = "<<SECUREShutdown<<endl;
	//cout<<"Saving CPTShutdown = "<<CPTShutdown<<endl;
	if(SECUREShutdown > m_buildTime)
	{
		m_dp_tclFC_STCDPSECURE_TIME.s32SetData(SECUREShutdown);
		DLT_LOG(STC_PDD, DLT_LOG_INFO,DLT_STRING("[INFO]  Save Secure Time : "),DLT_UINT64(SECUREShutdown));
		if(CPTShutdown > 0) 
		{
			//(CPTShutdown > 0) is added because last CAN CPT_value is overwritten to 0 when CAN is not connected and shutdown happens
			m_dp_tclFC_STCDPCPT_TEMPOREL_TIME.s32SetData(CPTShutdown);
			//cout<<"Saved CPTShutdown = "<<CPTShutdown<<endl;
			//cout<<"Saved SECUREShutdown = "<<SECUREShutdown<<endl;
			DLT_LOG(STC_PDD, DLT_LOG_INFO,DLT_STRING("[INFO] Save CPT value : "),DLT_UINT64(CPTShutdown));
		}
		//cout<<"Saved SECUREShutdown = "<<SECUREShutdown<<endl;
	}
}
//END_OF_FILE
