/************************************************************************
 * FILE:         fc_tclSTC_CSMCallbackHandler.cpp
 * PROJECT:      PSA-RCC
 * SW-COMPONENT: fc_STC
 *----------------------------------------------------------------------
 *
 * DESCRIPTION: This file contains the implementation of callback handlers
 *
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2008 Robert Bosch GmbH, Hildesheim
 * HISTORY:
 * Date      | Author		                   		  | Modification
 * 14.11.14  | RBEI/ECP4 ARJUN KUMAR R L              | initial version
 
 *************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "dlt/dlt.h"

DLT_DECLARE_CONTEXT(STC_CSM)
//#define	MIDW_COMMON_S_IMPORT_INTERFACE_CSM
//#include "midw_common_if.h"


#include "../include/fc_tclSTC_CSMCallbackHandler.h"

//Initialising of the static variables

fc_tclSTC_CSMCallbackHandler* fc_tclSTC_CSMCallbackHandler::m_pSTCCSMCallBackHandler = OSAL_NULL;
tU32 fc_tclSTC_CSMCallbackHandler::m_PrevCPT = 0;

/*************************************************************************
 *
 * FUNCTION: fc_tclSTC_CSMCallbackHandler::fc_tclSTC_CSMCallbackHandler()
 *
 * DESCRIPTION: constructor,
 *
 * PARAMETER: none
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
fc_tclSTC_CSMCallbackHandler::fc_tclSTC_CSMCallbackHandler()
{
	DLT_REGISTER_CONTEXT(STC_CSM,"CSM0","Registration of FCSTC CSM");
	
	//cout<<"fc_tclSTC_CSMCallbackHandler constructor"<<endl;
	m_pSTCCSMCallBackHandler 	= this;
	pCsmAccessUser	 			= OSAL_NULL;
	bUpdateStatus = false;
	m_pogetSTCPDD = NULL;
	m_pogetfc_tclSTCDbusStub = NULL;
	m_CPTValue = 0;
	m_TickCounter = 0;
	//m_SignalLength.insert(std::pair<tU32, tU8>(CSM_C_SIG_RX_CPT_TEMPOREL_ID_DONNEES_BSI_LENTES_2, 4));//epoch CSM_C_SIG_RX_CPT_TEMPOREL_ID_DONNEES_BSI_LENTES_2
	bStartCSMCommunication();

}

/*************************************************************************
 *
 * FUNCTION: fc_tclSTC_CSMCallbackHandler::~fc_tclSTC_CSMCallbackHandler()
 *
 * DESCRIPTION: destructor
 *
 * PARAMETER: none
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
fc_tclSTC_CSMCallbackHandler::~fc_tclSTC_CSMCallbackHandler()
{
	DLT_UNREGISTER_CONTEXT(STC_CSM);
	//cout<<"fc_tclSTC_CSMCallbackHandler destructor"<<endl;
	delete pCsmAccessUser;
	pCsmAccessUser 					= OSAL_NULL;
	if(m_pogetSTCPDD != NULL)
	{
		m_pogetSTCPDD = NULL;
	}
	if(m_pogetfc_tclSTCDbusStub != NULL)
	{
		m_pogetfc_tclSTCDbusStub = NULL;
	}
	
}

/*************************************************************************
 *
 * FUNCTION: fc_tclSTC_CSMCallbackHandler::poGetfc_tclSTC_CSMCallbackHandlerInstance()
 *
 * DESCRIPTION: destructor
 *
 * PARAMETER: none
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
fc_tclSTC_CSMCallbackHandler* fc_tclSTC_CSMCallbackHandler::poGetfc_tclSTC_CSMCallbackHandlerInstance()
{
	//cout<<"poGetfc_tclSTC_CSMCallbackHandlerInstance "<<endl;
	return m_pSTCCSMCallBackHandler;
}

/*************************************************************************
 *
 * FUNCTION: bStartCSMCommunication()
 *
 * DESCRIPTION: Function which starts the communication with CSM
 *
 * PARAMETER: none
 *
 * RETURNVALUE: Success/Failure
 *
 *************************************************************************/
bool fc_tclSTC_CSMCallbackHandler::bStartCSMCommunication()
{	
	//cout<<"fc_tclSTC_CSMCallbackHandler bStartCSMCommunication"<<endl;
	//ETG_TRACE_USR4(("bStartCSMCommunication"));
	bool bStartCommunicationResult = true;
	bStartCommunicationResult = bGetCSMHandler();

	//Proceed only if the CSM handler is available
	if(bStartCommunicationResult)
	{
		bStartCommunicationResult = bRegisterForBroadCastSignals();
	}
	return bStartCommunicationResult;
}

/*************************************************************************
 *
 * FUNCTION: vCloseCSMCommunication
 *
 * DESCRIPTION: Does the DeInit for CSM
 *
 * PARAMETER: none
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
void fc_tclSTC_CSMCallbackHandler::vCloseCSMCommunication()
{
	//ETG_TRACE_USR4(("vCloseCSMCommunication"));
	//cout<<"fc_tclSTC_CSMCallbackHandler vCloseCSMCommunication"<<endl;
	if(OSAL_NULL != pCsmAccessUser)
	{
		pCsmAccessUser->s32ApplCallbackDeInit();
	}
}

/*************************************************************************
 *
 * FUNCTION: bRegisterForBroadCastSignals
 *
 * DESCRIPTION: Function which manages the registration for BC signals
 *
 * PARAMETER: none
 *
 * RETURNVALUE: Success/Failure
 *
 *************************************************************************/
bool fc_tclSTC_CSMCallbackHandler::bRegisterForBroadCastSignals()
{
	//ETG_TRACE_USR4(("bRegisterForBroadCastSignals"));
	//cout<<"fc_tclSTC_CSMCallbackHandler bRegisterForBroadCastSignals"<<endl;
	bool bRegisterationResult = true;
	//Date and Time//////////////////////////////////////////////////////////////////////////////////////////////////////
	//bRegisterationResult = bRegisterForBrSignal(CSM_C_SIG_RX_CPT_TEMPOREL_ID_DONNEES_BSI_LENTES_2);
	
	return bRegisterationResult;
}

/*************************************************************************
 *
 * FUNCTION: bGetCSMHandler
 *
 * DESCRIPTION: Returns Handler from CSM, one handler per application
 *
 * PARAMETER: none
 *
 * RETURNVALUE: Success/Failure
 *
 *************************************************************************/
bool fc_tclSTC_CSMCallbackHandler::bGetCSMHandler()
{	
	//ETG_TRACE_USR4(("bGetCSMHandler"));
	//cout<<"fc_tclSTC_CSMCallbackHandler bGetCSMHandler"<<endl;
	bool bCSMHandlerResult = false;

	/** Get the CSM handle  CSM PreInit*/
	pCsmAccessUser = new csm_tclCsmAccessUser();
	if(OSAL_NULL != pCsmAccessUser)
	{
		pCsmAccessUser->vApplCallbackPreInit();
		bCSMHandlerResult = true;
	}

	return bCSMHandlerResult ;
}

/*************************************************************************
 *
 * FUNCTION: objGetCSMAccessUser
 *
 * DESCRIPTION: Returns csm_tclCsmAccessUser obj
 *
 * PARAMETER: none
 *
 * RETURNVALUE: Success/Failure
 *
 *************************************************************************/
csm_tclCsmAccessUser* fc_tclSTC_CSMCallbackHandler::objGetCSMAccessUser()
{	
	//ETG_TRACE_USR4(("objGetCSMAccessUser"));
	//cout<<"fc_tclSTC_CSMCallbackHandler objGetCSMAccessUser"<<endl;
	return pCsmAccessUser ;
}


/*************************************************************************
 *
 * FUNCTION: bRegisterForBrSignal
 *
 * DESCRIPTION: Function which manages the registration for BC signals
 *
 * PARAMETER: s32SigID : Signal ID
 *
 * RETURNVALUE: Success/Failure
 *
 *************************************************************************/
bool fc_tclSTC_CSMCallbackHandler::bRegisterForBrSignal(tS32 s32SigID)
{
	//ETG_TRACE_USR4(("bRegisterForBrSignal: s32SigID= %d", s32SigID));
	//cout<<"bRegisterForBrSignal "<<endl;
	bool bRegisterForBrResult = false;
	tS32  s32ReturnValue = CSM_C_NO_ERROR ;

	/* CSM Library function for registration for Broad cast signal callback... */
	if(OSAL_NULL != pCsmAccessUser)
	{
		//cout<<"bRegisterForBrSignal s32SignalCallbackInit"<<endl;
		s32ReturnValue = pCsmAccessUser->s32SignalCallbackInit(s32SigID,(tCSM_PFN_CBR_SIGNAL_IND)vCSMSignalCallback);
	}

	if( s32ReturnValue >= CSM_C_NO_ERROR )
	{
		bRegisterForBrResult = true ;
	}
	else/*  callback is not registered */
	{
		//ETG_TRACE_USR4(("bRegisterForBrSignal: callback not registered"));
	}

	return bRegisterForBrResult ;
}

/*************************************************************************
 *
 * FUNCTION: vCSMSignalCallback
 *
 * DESCRIPTION: Fucntion which manages the callbacks for broacast signals
 *
 * PARAMETER: void *pvHandle - Pointer for the CSM handler
 *            tU32 u32SignalID - Signal ID
 *            tU32 u32SignalState - Signal state
 *
 * RETURNVALUE: None
 *
 *************************************************************************/
void fc_tclSTC_CSMCallbackHandler::vCSMSignalCallback( void *pvHandle, tU32 u32SignalID, tU32 u32SignalState )
{
	//ETG_TRACE_USR4(("vCSMSignalCallback: u32SignalID= %d, u32SignalState= %d", u32SignalID, u32SignalState));
	(void)pvHandle;
	(void)u32SignalState;
	//cout<<"fc_tclSTC_CSMCallbackHandler::vCSMSignalCallback"<<endl;

    if(1) 
	{

		if(m_pSTCCSMCallBackHandler)
		{
			m_pSTCCSMCallBackHandler->vGetCSMdata();
		}
	}
	else
	{
		//cout<<"OTHER"<<endl;
    }
}
/*************************************************************************
 *
 * FUNCTION: vGetCSMdata
 *
 * DESCRIPTION: Function to Read the value from CSM_C_SIG_RX_CPT_TEMPOREL_ID_DONNEES_BSI_LENTES_2
 *
 * PARAMETER: None
 *
 * RETURNVALUE: None
 *
 *************************************************************************/
void fc_tclSTC_CSMCallbackHandler::vGetCSMdata()
{
	tU8 u8Length = 4; // Four byte data length
	tU32 u32ReadStatus = CSM_C_NO_ERROR;
	tS32 s32Ret = CSM_C_NO_ERROR;
	tU32 pu8CANData = 0;// lint warning

	if(OSAL_NULL != pCsmAccessUser)
	{
		//s32Ret = pCsmAccessUser->s32SignalRead(CSM_C_SIG_RX_CPT_TEMPOREL_ID_DONNEES_BSI_LENTES_2,&pu8CANData, u8Length, &u32ReadStatus);
	}
	if(pu8CANData <= 4294967293u)
	{
		m_CPTValue = pu8CANData/10;    		// Raw data increments by value 10: for every second
		//cout<<"m_CPTValue = "<<m_CPTValue<<endl;
		if(bUpdateStatus == false)
		{
			bUpdateStatus = true;
			vInitialiseSecureTime(m_CPTValue);
			m_PrevCPT = m_CPTValue;
		}
		else
		{
			if(m_CPTValue > m_PrevCPT)            // If overflow happens do not increment fc_stc time
			{
				tU32 uTick = m_CPTValue - m_PrevCPT;
				if(( uTick >= 1 ))  // To account for event: (If Many event happens in 1 second ) 
				{
					m_PrevCPT = m_CPTValue;
					m_TickCounter = m_TickCounter + uTick; // uTick itself is added instead of 1. CPT_TEMPOREL may not be received for 10 to 12 seconds
					//cout<<"Incremented Tick "<<m_CPTValue<<endl;
				}	
			}
			
		}
		
	}
}

/*************************************************************************
 *
 * FUNCTION: vInitialiseSecureTime()
 *
 * DESCRIPTION: Initalises the secure time
 *
 * PARAMETER: none
 *
 * RETURNVALUE: Void
 *
 *************************************************************************/
void fc_tclSTC_CSMCallbackHandler::vInitialiseSecureTime(tU32 Time)
{	
	//cout<<"fc_tclSTC_CSMCallbackHandler::vInitialiseSecureTime()"<<endl;
	tU64 LastCPT = 0;//LInt warning
	tU64 DeltaCPT;
	tU64 FirstCPT = (tU64)Time;
	m_pogetSTCPDD = fc_tclSTC_PDD::m_poGetm_pofc_tclSTC_PDDInstance();
	if(m_pogetSTCPDD != NULL)
		LastCPT = m_pogetSTCPDD->ReturnLastSavedCPTtime();
	if(LastCPT == 0) // Its first boot
	{
		m_pogetfc_tclSTCDbusStub = fc_tclSTCDbusStub::m_poGetfc_tclSTCDbusStubInstance();
		if(m_pogetfc_tclSTCDbusStub != NULL)
		{
			m_pogetfc_tclSTCDbusStub->vSendCPTdifference((tU64)0); //lint warning 
		}
	}
	else 
	{
		//m_pogetSTCPDD = fc_tclSTC_PDD::m_poGetm_pofc_tclSTC_PDDInstance();
		if(m_pogetSTCPDD != NULL)
		{
			//LastCPT = m_pogetSTCPDD->ReturnLastSavedCPTtime();
			//cout<<"FirstCPT = "<<FirstCPT<<endl;
			//cout<<"LastCPT = "<<LastCPT<<endl;
			DLT_LOG(STC_CSM, DLT_LOG_INFO,DLT_STRING("[INFO] First CPT value : "),DLT_UINT64(FirstCPT));
			if( FirstCPT >= LastCPT)
			{
				DeltaCPT = FirstCPT - LastCPT;
				//cout<<"DeltaCPT = "<<DeltaCPT<<endl;
				m_pogetfc_tclSTCDbusStub = fc_tclSTCDbusStub::m_poGetfc_tclSTCDbusStubInstance();
				if(m_pogetfc_tclSTCDbusStub != NULL)
				{
					if(DeltaCPT < (tU64)MAX_CPTTEMPOREL_DIFFERENCE)
						m_pogetfc_tclSTCDbusStub->vSendCPTdifference(DeltaCPT);
				}
			}
		
		}
	}
}

/*************************************************************************
 *
 * FUNCTION: vSaveCPTandSecureTimeOnShutdown
 *
 * DESCRIPTION: Saves the SecureTime  and CPT tick Counter to pdd
 *
 * PARAMETER: none
 *
 * RETURNVALUE: void
 *
 *************************************************************************/
void fc_tclSTC_CSMCallbackHandler::vSaveCPTandSecureTimeOnShutdown(bool GPSstatus, tU64 GpsTick)
{	
	//ETG_TRACE_USR4(("objGetCSMAccessUser"));
	//cout<<"fc_tclSTC_CSMCallbackHandler::vSaveCPTandSecureTimeOnShutdown()"<<endl;
	tU64 TickCounter = (tU64)m_TickCounter;
	tU64 CPTValue = (tU64)m_CPTValue;
	tU64 Securetime = 0;

	m_pogetSTCPDD = fc_tclSTC_PDD::m_poGetm_pofc_tclSTC_PDDInstance();
	if(m_pogetSTCPDD != NULL)
	{
		m_pogetfc_tclSTCDbusStub = fc_tclSTCDbusStub::m_poGetfc_tclSTCDbusStubInstance();
		if(m_pogetfc_tclSTCDbusStub != NULL)
		{	
			if(GPSstatus == true)
			{
				Securetime = (m_pogetfc_tclSTCDbusStub->u64ReturnActualSecureTime()) + GpsTick;
				//cout<<"(m_pogetfc_tclSTCDbusStub->u64ReturnActualSecureTime() = " <<m_pogetfc_tclSTCDbusStub->u64ReturnActualSecureTime()<< endl;
				//cout<<"GpsTick = " <<GpsTick<< endl;
			}
			else
			{
			
				Securetime = (m_pogetfc_tclSTCDbusStub->u64ReturnActualSecureTime()) + TickCounter;
			
				//cout<<"(m_pogetfc_tclSTCDbusStub->u64ReturnActualSecureTime() = " <<m_pogetfc_tclSTCDbusStub->u64ReturnActualSecureTime()<< endl;
				//cout<<"saving TickCounter = "<<TickCounter<<endl;
			}
		}


		m_pogetSTCPDD->vSaveCPTandSECUREtime(Securetime,CPTValue);
		//cout<<"saving Securetime = "<<Securetime<<endl;
		//cout<<"saving (TickCounter + (tU64)m_CPTValue) = "<<(TickCounter + (tU64)m_CPTValue)<<endl;
		//cout<<"m_CPTValue = "<<m_CPTValue<<endl;

	}
}


/*************************************************************************
 *
 * FUNCTION: vIncrementSecureTime
 *
 * DESCRIPTION: For ticking the secure time
 *
 * PARAMETER: NA
 *
 * RETURNVALUE: bool
 *
 *************************************************************************/
void fc_tclSTC_CSMCallbackHandler::vIncrementCSMCounter()
{	
	//cout<<"fc_tclSTC_CSMCallbackHandler::vIncrementSecureTime()"<<endl;
	m_TickCounter = m_TickCounter + 1;
	
}


/*************************************************************************
 *
 * FUNCTION: u32ReturnCPTTickCounter()
 *
 * DESCRIPTION: For ticking the secure time
 *
 * PARAMETER: NA
 *
 * RETURNVALUE: bool
 *
 *************************************************************************/
tU64 fc_tclSTC_CSMCallbackHandler::u32ReturnCPTTickCounter()
{	
	//cout<<"fc_tclSTC_CSMCallbackHandler::u32ReturnCPTTickCounter()"<<endl;
	//cout<<"m_TickCounter = "<<m_TickCounter<<endl;
	tU64 TickCount = (tU64)m_TickCounter;
	//cout<<"TickCount = "<<TickCount<<endl;
	return TickCount;
}

/*************************************************************************
 *
 * FUNCTION: vResetTickCounter
 *
 * DESCRIPTION: For resetting the counter
 *
 * PARAMETER: NA
 *
 * RETURNVALUE: NA
 *
 *************************************************************************/
void fc_tclSTC_CSMCallbackHandler::vResetTickCounter()
{
	//cout<<"fc_tclSTC_CSMCallbackHandler::vResetTickCounter()"<<endl;
	m_TickCounter = 0;
}

/**********************************************************************
 * Function       : bReturnShutDownCAL
 * Description    : To return Whether shutdown calculation is done or NOT
 * Parameters     : NA
 * Return value   : tU64
 * History        : Date		| Author				| Modification
					01.02.2016	| Arjun Kumar R L		| Initial Version
 **********************************************************************/
bool fc_tclSTC_CSMCallbackHandler::bReturnShutDownCAL()
{
	return bUpdateStatus;
}

//END_OF_FILE
