/*****************************************************************************
* FILE 			: FC_tclHostapdClient.h
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	: ASF FC_Hostapd Dbus Stub
*
* DESCRIPTION 	: This class interects with hostapd daemon and send/receive data 
*					to/from hostapd
*		         
* AUTHOR 		: Rana Satyavrat Singh (RBEI/ECP4)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY: 
   Date			 | Author			        | Modification
   08.02.2016	 | Rana Satyavrat Singh			| Initial Version	
****************************************************************************/
#ifndef FC_TCLGNSSENSORCCACLIENTHANDLER_HEADER
#define FC_TCLGNSSENSORCCACLIENTHANDLER_HEADER

#define IS_LEAP_YEAR(Y)     ( ((Y)>0) && !((Y)%4) && ( ((Y)%100) || !((Y)%400) ) )
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <time.h>
#include "fc_tclSTC_PDD.h"
#include "fc_tclSTC_CSMCallbackHandler.h"
#include "fc_tclSTCDbusStub.h"
#include <iostream>
#include "sensor_location_fiProxy.h"
#include "location_fi_types.h"



using namespace std;
using namespace ::asf::core;
using namespace ::sensor_location_fi;
using namespace ::location_fi_types;

class fc_tclSTCDbusStub;

class Fc_tclGNSsensorCCAClientHandler:public ServiceAvailableIF,
									  public GnssDataCallbackIF
{

public:	
	//Constructor
	Fc_tclGNSsensorCCAClientHandler();
	
	//Destructor
	~Fc_tclGNSsensorCCAClientHandler();
	
	//Method to return self referential Stub pointer
	static Fc_tclGNSsensorCCAClientHandler * poGetFc_tclGNSsensorCCAClientHandler();
	
	virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange &stateChange);
    virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange &stateChange);

	    /** class GnssDataCallbackIF implementation */
    virtual void onGnssDataError(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssDataError >& error);
    virtual void onGnssDataStatus(const ::boost::shared_ptr< Sensor_location_fiProxy >& proxy, const ::boost::shared_ptr< GnssDataStatus >& status);

    tU64 u64ReturnGPSTickCounter();

    bool bReturnGPSUPDATEStatus();

private:
    static Fc_tclGNSsensorCCAClientHandler * m_poFc_tclGNSsensorCCAClientHandler;
	
	::boost::shared_ptr< Sensor_location_fiProxy >_sensorccaproxy;

	 bool bGPSUPDATEStatus;

	 tU32 mGPSTickCounter;

	fc_tclSTCDbusStub* m_poGetfc_tclSTCDbusStub;
};

#endif

//End of File 
