/*****************************************************************************
* FILE 			: FC_STCMain.h
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	: ASF Connectivity component
*
* DESCRIPTION 	: Main Component class which implements LCM interfaces and Initializes other stub and proxy classes
*				  
* AUTHOR 		: Arjun Kumar R L (RBEI/ECP4)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY: 
   Date			 | Author			        | Modification
   01.01.2017	 | Arjun Kumar R L			| initial version			  
****************************************************************************/

#ifndef FC_STC_MAIN_H
#define FC_STC_MAIN_H

#include <iostream>
#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"
//#include "org/bosch/cm/lcm/lcmbaseappcomponent/LcmBaseAppComponent.h"

#include "include/fc_tclSTC_PDD.h"
#include "include/fc_tclSTC_CSMCallbackHandler.h"
#include "include/Fc_tclGNSsensorCCAClientHandler.h"
#include "include/fc_tclSTCDbusStub.h"

using namespace std;
using namespace ::asf::core;
// Using the namespaces of lcm component
//using namespace ::org::bosch::cm::lcm;
//using namespace ::org::genivi::NodeStateManager::Consumer;
//using namespace ::org::genivi::NodeStateManager::LifeCycleConsumer;
//using namespace ::org::genivi::NodeStateManager::LifecycleControl;
//using namespace ::org::bosch::cm::lcm::lcmbaseappcomponent;

//Forward Declaration of local classes

namespace FC_STC
{
	class FC_STCMain : public BaseComponent//,public LcmApplicationControlIF
	{
	   public:
		//Constructor
		FC_STCMain(); 

		//Destructor
		virtual ~FC_STCMain();
		
		//virtual _NsmErrorStatus_e OnAppModeChange(_Nsm_Shutdown_Type_e newAppMode, _Nsm_Shutdown_Type_e oldAppMode);

		//Function called on application
		virtual bool   OnAppWatchdog();
	
		//Called onLcmRegistered
		virtual void   OnLcmRegistered();
	
		//Called when spm service is available
		virtual void   OnAvailable();
	
		//LcmBaseAppComponent _lcmAppComponent;	

	  private:
		
		fc_tclSTC_CSMCallbackHandler * m_fc_tclSTC_CSMCallbackHandler;
		fc_tclSTC_PDD * m_fc_tclSTC_PDDHandler;
		Fc_tclGNSsensorCCAClientHandler * m_Fc_tclGNSsensorCCAClientHandler;
		fc_tclSTCDbusStub* m_fc_tclSTCDbusStubHandler;
	};	
}
#endif // FC_STC_MAIN_H

//End of File
