/***************************************************************************
 *                                                                         *
 * Copyright                                                               *
 *     escrypt GmbH, Bochum, Germany                                       *
 *     Lise-Meitner-Allee 4                                                *
 *     D-44801 Bochum, Germany                                             *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        pkcs10_utils.c

   \brief       PKCS#10 Utilities Module

   ***

   $Rev: 937 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2019-02-20 16:27:46 +0100 (Mi, 20. Feb 2019) $
****************************************************************************/

#ifndef PKCS10_INC_PKCS10_UTILS_H_
#define PKCS10_INC_PKCS10_UTILS_H_

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/
/* common headers */
#include <esc_common.h>
#include "pkcs10.h"
#include <pthread.h>
#include <dbus/dbus.h>

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/***************************************************************************
 * 3. DECLARATIONS                                                         *
 ***************************************************************************/

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. FUNCTION PROTOTYPES                                                  *
 ***************************************************************************/

volatile BOOL runPKCS10DBusService;

/**
This function is used to create a PKCS#10 CSR

\param[in] pkcs10Data
    Pointer where PKCS#10 data is stored

\param[out] dataOut
    Pointer where PKCS#10 message is stored
\param[out] dataOutLen
    Pointer where length of PKCS#10 message is stored

\return #BOOL
\retval #FALSE on success
\retval #TRUE on failure

*/
BOOL
createPKCS10CSR (
    PKCS10_DATA_s *pkcs10Data,
    UINT8 **dataOut,
    UINT32 *dataOutLen );

/**
This function is used to free PKCS#10 specific data from the global structure

\param[in] pkcs10data
    Pointer to PKCS#10 data to free

*/
void
freePkcs10Data (
    PKCS10_DATA_s *pkcs10data );

/***************************************************************************
 * 6. MACRO FUNCTIONS                                                      *
 ***************************************************************************/

/***************************************************************************
 * 7. END                                                                  *
 ***************************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* PKCS10_INC_PKCS10_UTILS_H_ */
