/***************************************************************************
 *                                                                         *
 * Copyright                                                               *
 *     escrypt GmbH, Bochum, Germany                                       *
 *     Lise-Meitner-Allee 4                                                *
 *     D-44801 Bochum, Germany                                             *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        pkcs10.h

   \brief       Main module of PKCS#10 library

   ***

   $Rev: 937 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2019-02-20 16:27:46 +0100 (Mi, 20. Feb 2019) $
****************************************************************************/

#ifndef PKCS10_INC_PKCS10_H_
#define PKCS10_INC_PKCS10_H_

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/

#include "../../crypto/inc/crypto.h"
#include "../../common/inc/esc_common.h"
#include <pthread.h>

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/** Maximum size of an encoded PKCS#10 message */
#define MAX_ENC_PKCS10_MESSAGE_LEN 2048

/** PKCS#10 data structure */
typedef struct {
    /** Hash algorithm used */
    HASH_t hashAlg;
    /** Pointer to unique ID source name */
    char *uniqueIdSrc;
    /** Flag to signal if selected device unique ID
        should be set as CN instead */
    BOOL setUniqueIdAsCn;
    /** Pointer to device unique ID */
    char *deviceUniqueId;
    /** Pointer to device unique ID backup */
    char *deviceUniqueIdBak;
    /** Pointer to PKCS1 encoded device public key */
    UINT8 *pkcs1PubKey;
    /** Size of PKCS1 encoded device public key */
    UINT32 pkcs1PubKeySize;
    /** Key size ID */
    UINT32 keySize;
    /** Pointer to device key pair structure */
    void* keyPair;
    /** Flag if CSR was already requested */
    BOOL csrRequested;
    char *devCertUri;

} PKCS10_DATA_s;

/***************************************************************************
 * 3. DECLARATIONS                                                         *
 ***************************************************************************/

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. FUNCTION PROTOTYPES                                                  *
 ***************************************************************************/

/***************************************************************************
 * 6. MACRO FUNCTIONS                                                      *
 ***************************************************************************/

/***************************************************************************
 * 7. END                                                                  *
 ***************************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* PKCS10_INC_PKCS10_H_ */
