/***************************************************************************
 *                                                                         *
 * Copyright                                                               *
 *     escrypt GmbH, Bochum, Germany                                       *
 *     Lise-Meitner-Allee 4                                                *
 *     D-44801 Bochum, Germany                                             *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        ecm_cm_sdc_utils.c

   \brief       Utilities module for CMs SDC

   $Rev: 937 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2019-02-20 16:27:46 +0100 (Mi, 20. Feb 2019) $
****************************************************************************/

/***************************************************************************
* 1. INCLUDES                                                              *
****************************************************************************/

#include "../inc/ecm.h"
#include <esc_debug.h>

#include "../inc/ecm_cm_sdc_utils.h"

#ifdef UNIT_TESTING
#include "ecmUnitTests.h"
#endif

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/***************************************************************************
 * 3. DEFINITIONS                                                          *
 ***************************************************************************/

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. IMPLEMENTATION OF FUNCTIONS                                          *
 ***************************************************************************/

#ifdef CONFIG_ECM_USE_SDC
BOOL checkSdcRet (
    sdc_error_t ret )
{
    BOOL failed = FALSE;

    dbgIn ( __func__ );

    if ( ret != SDC_OK ) {
        dbgPrint ( DBG_ERR, DBG_FLS "SDC %s\n", DBG_FL, sdc_get_error_string(ret ));
        failed = TRUE;
    }

    dbgOut ( __func__ );

    return ( failed );
}

BOOL appendSdcSuffix ( UINT8 **dst ) {

    BOOL failed = FALSE;
    size_t reallocLen = 0;
    size_t s = 0;

    dbgIn ( __func__ );

    /* sanity checks */
    if ( !dst || !*dst ) {
        dbgPrint ( DBG_ERR, DBG_FLS "Invalid parameter!\n", DBG_FL );
        failed = TRUE;
    }

    ifNotFailed {
        s = strlen ( (char *) *dst ) + strlen ( SDC_WRAP_SUFFIX ) + 2;
        if ( s < strlen ( (char *) *dst ) ) {
            /* s seems to wrap arround */
            failed = TRUE;
        }
    }
    ifNotFailed {

        reallocLen = s;
        *dst = realloc ( *dst, reallocLen );
        if ( NULL == *dst ) {
            failed = TRUE;
        }
    }
    ifNotFailed {
        strncat ( (char *) *dst, SDC_WRAP_SUFFIX, reallocLen - strlen ( (char *) *dst ) + 1);
    }

    dbgOut ( __func__ );

    return ( failed );
}

BOOL setupSdcSession (
    SDC_PARAMS_s *sdc,
    UINT32 keyId )
{
    BOOL failed = FALSE;
    sdc_error_t ret;

    dbgIn ( __func__ );

    /* sanity checks */
    if ( !sdc ) {
        dbgPrint ( DBG_ERR, DBG_FLS "Invalid parameter!\n", DBG_FL );
        failed = TRUE;
    }

    ifNotFailed {
        sdc->execSdcOp = TRUE;
        sdc->keyId = keyId;
        ret = sdc_session_load_storage_key ( sdc->session, keyId );
        failed = checkSdcRet( ret );
    }

    dbgOut ( __func__ );

    return ( failed );
}

BOOL releaseSdcSession (
    SDC_PARAMS_s *sdc )
{
    BOOL failed = FALSE;
    sdc_error_t ret;

    dbgIn ( __func__ );

    /* sanity checks */
    if ( !sdc ) {
        dbgPrint ( DBG_ERR, DBG_FLS "Invalid parameter!\n", DBG_FL );
        failed = TRUE;
    }

    ifNotFailed {
        sdc->keyId = -1;
        sdc->execSdcOp = FALSE;
        ret = sdc_session_unset_key( sdc->session );
        failed = checkSdcRet( ret );
    }

    dbgOut ( __func__ );

    return ( failed );
}

#endif /* CONFIG_ECM_USE_SDC */

/***************************************************************************
 * 6. END                                                                  *
 ***************************************************************************/
