/***************************************************************************
 *                                                                         *
 * Copyright                                                               *
 *     escrypt GmbH, Bochum, Germany                                       *
 *     Lise-Meitner-Allee 4                                                *
 *     D-44801 Bochum, Germany                                             *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        ecm_cm_sdc_utils.h

   \brief       Utilities module for CMs SDC

   ***

   $Rev: 937 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2019-02-20 16:27:46 +0100 (Mi, 20. Feb 2019) $
****************************************************************************/

#ifndef _ECM_INC_ECM_CM_SDC_UTILS_H_
#define _ECM_INC_ECM_CM_SDC_UTILS_H_

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/

#ifdef CONFIG_ECM_USE_SDC
#include "../../sdc/inc/sdc.h"
#include "../../sdc/inc/sdc_session.h"
#include "../../sdc/inc/sdc_keystore_keys.h"
#include "../../sdc/inc/sdc_op_conv.h"
#include "../../sdc/inc/sdc_op_common.h"
#include "../../sdc/inc/sdc_perm.h"
#endif /* CONFIG_ECM_USE_SDC */

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/** Structure containing SDC related parameters */
typedef struct {
    /** Flag that signals if SDC operation should be executed */
    BOOL execSdcOp;
#ifdef CONFIG_ECM_USE_SDC
    /** Identifier of SDC key to use */
    UINT32 keyId;
    /** Identifier of SDC key used for UIN wrapping */
    UINT32 uinWrapKeyId;
    /** Identifier of SDC key used for device key wrapping */
    UINT32 devKeyWrapKeyId;
    /** Identifier of SDC key used for certificate wrapping */
    UINT32 certWrapKeyId;
    /** SDC error code */
    sdc_error_t err;
    /** SDC session pointer */
    sdc_session_t *session;
    /** SDC wrapping / unwrapping algorithm / mode */
    sdc_wrap_unwrap_type_t *type;
#endif /* CONFIG_ECM_USE_SDC */
} SDC_PARAMS_s;

/***************************************************************************
 * 3. DECLARATIONS                                                         *
 ***************************************************************************/

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. FUNCTION PROTOTYPES                                                  *
 ***************************************************************************/

#ifdef CONFIG_ECM_USE_SDC

/**
This function checks the SDC return code

\param[in] ret
    SDC return code

\return #BOOL
\retval #FALSE on success, means SDC return code is SDC_OK
\retval #TRUE on failure, means SDC return code is not SDC_OK
*/

BOOL
checkSdcRet (
    sdc_error_t ret );

/**
This function is used to append ".wrap" to given strings

\param[in] dst
    Pointer to pointer where string has to be stored

\return #BOOL
\retval #FALSE on success
\retval #TRUE on failure
*/
BOOL
appendSdcSuffix (
    UINT8 **dst );

/**
This function initializes a SDC session

\param[in] sdc
    Pointer to SDC parameters structure

\param[in] keyId
    Key identifier to use

\return #BOOL
\retval #FALSE on success
\retval #TRUE on failure
*/
BOOL
setupSdcSession (
    SDC_PARAMS_s *sdc,
    UINT32 keyId );

/**
This function releases a SDC session

\param[in] sdc
    Pointer to SDC parameters structure

\return #BOOL
\retval #FALSE on success
\retval #TRUE on failure
*/
BOOL
releaseSdcSession (
    SDC_PARAMS_s *sdc );

#endif /* CONFIG_ECM_USE_SDC */

/***************************************************************************
 * 6. MACRO FUNCTIONS                                                      *
 ***************************************************************************/

/***************************************************************************
 * 7. END                                                                  *
 ***************************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* ECM_INC_ECM_CM_SDC_UTILS_H_ */
