/***************************************************************************
 * Copyright                                                               *
 *                                                                         *
 *     ESCRYPT GmbH - Embedded Security       ESCRYPT Inc.                 *
 *     Zentrum fuer IT-Sicherheit             315 E Eisenhower Parkway     *
 *     Lise-Meitner-Allee 4                   Suite 214                    *
 *     44801 Bochum                           Ann Arbor, MI 48108          *
 *     Germany                                USA                          *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        watchdog.h

   \brief       User implementation of Watchdog function

   This file provides a dummy implementation of the watchdog function
   EscWatchdog_CallStatic(), which is called in modules which support
   a watchdog, but don't receive a watchdog function pointer
   as argument, e.g. the ECC module.

   The dummy implementation basically does nothing, it just returns.
   To implement a static watchdog handler, edit this file
   or provide a EscWatchdog_CallStatic function in a different
   location. The prototype of this function is located in cycurlib_config.h.

   This header file declares nothing. The prototype for
   EscWatchdog_CallStatic() is located in cycurlib_config.h.

   $Rev: 86 $

 */
/***************************************************************************/

#ifndef _ESC_WATCHDOG_H_
#define _ESC_WATCHDOG_H_

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/

#include "cycurlib_config.h"

#ifdef  __cplusplus
/* *INDENT-OFF* */
extern "C" {
 /* *INDENT-ON* */
#endif

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/***************************************************************************
 * 3. DECLARATIONS                                                         *
 ***************************************************************************/

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. FUNCTION PROTOTYPES                                                  *
 ***************************************************************************/

/***************************************************************************
 * 6. MACRO FUNCTIONS                                                      *
 ***************************************************************************/
#ifdef  __cplusplus
/* *INDENT-OFF* */
}
/* *INDENT-ON* */
#endif /*
*/

#endif /*
*/
/***************************************************************************
 * 7. END                                                                  *
 ***************************************************************************/
