/***************************************************************************
 * Copyright                                                               *
 *                                                                         *
 *     ESCRYPT GmbH - Embedded Security       ESCRYPT Inc.                 *
 *     Zentrum fuer IT-Sicherheit             315 E Eisenhower Parkway     *
 *     Lise-Meitner-Allee 4                   Suite 214                    *
 *     44801 Bochum                           Ann Arbor, MI 48108          *
 *     Germany                                USA                          *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        BIGINTEGER.c

   \brief       BIGINTEGER for ASN1C

   $Rev: 601 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2016-04-22 17:25:28 +0200 (Fr, 22. Apr 2016) $

History:
11-Feb-2013 DV ------------------------ Creation ---------------------------

$ENDOFHISTORY$
****************************************************************************/

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/
#include "OCTET_STRING.h"
#include <esc_common.h>
#include "BIGINTEGER.h"

/*
 * BIGINTEGER basic type description based on OCTET_STRING.
 */

/** BIGINTEGER TAG definition based on INTEGER */
static ber_tlv_tag_t asn_DEF_BIGINTEGER_tags[ ] = { ( ASN_TAG_CLASS_UNIVERSAL | ( 2 << 2 ) ) };

/** BIGINTEGER definition based on OCTET_STRING */
static asn_OCTET_STRING_specifics_t asn_DEF_BIGINTEGER_specs = { sizeof(BIGINTEGER_t), offsetof(BIGINTEGER_t, _asn_ctx), 0 };

/** BIGINTEGER definition based on OCTET_STRING */
asn_TYPE_descriptor_t asn_DEF_BIGINTEGER = {
    "BIGINTEGER",		            /* Canonical name */
    "BIGINTEGER",		            /* XML tag name */
    OCTET_STRING_free,
    OCTET_STRING_print,	            /* non-ascii stuff, generally */
    asn_generic_no_constraint,
    OCTET_STRING_decode_ber,
    OCTET_STRING_encode_der,
    OCTET_STRING_decode_xer_hex,
    OCTET_STRING_encode_xer,
    OCTET_STRING_decode_uper,	    /* Unaligned PER decoder */
    OCTET_STRING_encode_uper,	    /* Unaligned PER encoder */
    0,                              /* Use generic outmost tag fetcher */
    asn_DEF_BIGINTEGER_tags,
    sizeof( asn_DEF_BIGINTEGER_tags ) / sizeof( asn_DEF_BIGINTEGER_tags[ 0 ] ),
    asn_DEF_BIGINTEGER_tags,	    /* Same as above */
    sizeof( asn_DEF_BIGINTEGER_tags ) / sizeof( asn_DEF_BIGINTEGER_tags[ 0 ] ),
    0,	                            /* No PER visible constraints */
    0, 0,	                        /* No members */
    /* Adaption to work with asn1c v0.9.24 */
//    &asn_DEF_BIGINTEGER_specs
    0
};

BOOL setBigInteger( const UINT8* const input, const UINT32 length, BIGINTEGER_t* const dest ) {
    UINT32 len = length;
    const UINT8* buffer = input;
    BOOL hasFailed = TRUE;

    if ( input != NULL && dest != NULL && len > 1 ) {
        /* strip leading zeros preserving the signedness (unsigned) */
        while ( ( len > 1 ) && ( buffer[ 0 ] == 0x00U ) && ( buffer[ 1 ] < 0x80U ) ) {
            buffer++;
            len--;
        }
        hasFailed = ( OCTET_STRING_fromBuf( dest, (const char *)buffer, len ) != 0 );
    }
    return hasFailed;
}

BOOL getBigInteger( UINT8* const output, const UINT32 length, const BIGINTEGER_t* const dest ) {
    BOOL hasFailed = TRUE;
    if ( output != NULL && dest != NULL && dest->size <= length ) {
        UINT32 prefix = length - dest->size;
        memset( output, 0, prefix );
        memcpy( output + prefix, dest->buf, dest->size );
        hasFailed = FALSE;
    }
    return hasFailed;
}
