/***************************************************************************
 * Copyright                                                               *
 *                                                                         *
 *     ESCRYPT GmbH - Embedded Security       ESCRYPT Inc.                 *
 *     Zentrum fuer IT-Sicherheit             315 E Eisenhower Parkway     *
 *     Lise-Meitner-Allee 4                   Suite 214                    *
 *     44801 Bochum                           Ann Arbor, MI 48108          *
 *     Germany                                USA                          *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        BIGINTEGER.h

   \brief       BIGINTEGER for ASN1C

   $Rev: 602 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2016-04-29 17:49:57 +0200 (Fr, 29. Apr 2016) $

History:
11-Feb-2013 DV ------------------------ Creation ---------------------------

$ENDOFHISTORY$
****************************************************************************/
#ifndef	_BIGINTEGER_H_
#define	_BIGINTEGER_H_

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/
#include "../../cmp/asn1-2005-multi-file-os-asn1c/OCTET_STRING.h"

#include "esc_common.h"

#ifdef __cplusplus
extern "C" {
#endif


/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/***************************************************************************
 * 3. DECLARATIONS                                                         *
 ***************************************************************************/

/** BIGINTEGER basic type description based on OCTET_STRING. */
typedef OCTET_STRING_t BIGINTEGER_t;

/** BIGINTEGER definition based on OCTET_STRING */
extern asn_TYPE_descriptor_t asn_DEF_BIGINTEGER;

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. FUNCTION PROTOTYPES                                                  *
 ***************************************************************************/

/**
 * This functions fills a big integer (based on OCTET_STRING) from a buffer stripping leading zeros and preserving the signedness (unsigned).
 *
 * \param[in]   input       Big endian input buffer
 * \param[in]   length      Size of the input buffer
 * \param[out]  dest        BIGINTEGER field within the ASN1 struct
 *
 * \return                  TRUE on error; FALSE else
 */
extern BOOL setBigInteger( const UINT8* const input, const UINT32 length, BIGINTEGER_t* const dest );

/**
 * This functions read a big integer (based on OCTET_STRING) from an ASN1 struct.
 *
 * \param[out]  output      Big endian output buffer
 * \param[in]   length      Size of the output buffer
 * \param[in]   dest        BIGINTEGER field within the ASN1 struct
 *
 * \return                  TRUE on error; FALSE else
 */
extern BOOL getBigInteger( UINT8* const output, const UINT32 length, const BIGINTEGER_t* const dest );

#ifdef __cplusplus
}
#endif

#endif	/* _BIGINTEGER_H_ */
