/***************************************************************************
 *                                                                         *
 * Copyright                                                               *
 *     escrypt GmbH, Bochum, Germany                                       *
 *     Lise-Meitner-Allee 4                                                *
 *     D-44801 Bochum, Germany                                             *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        esc_debug_simple.c

   \brief       Common debug module for simple debugging

   $Rev: 780 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2017-07-28 15:40:59 +0200 (Fr, 28. Jul 2017) $
****************************************************************************/

/***************************************************************************
* 1. INCLUDES                                                              *
****************************************************************************/

/* linux headers */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <sys/types.h>
#include <unistd.h>

/* local header */
#include <esc_common.h>
#include <esc_debug_simple.h>


/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/** Maximum line length of a debug message */
# define MAX_LINE_LEN 128

/***************************************************************************
 * 3. DEFINITIONS                                                          *
 ***************************************************************************/

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. IMPLEMENTATION OF FUNCTIONS                                          *
 ***************************************************************************/

static UINT32 dbgMask = 0;


BOOL escInitLogging (
    UINT32 logLevel
    )
{
    dbgMask = logLevel;

    return ( FALSE );
}

BOOL escCloseLogging (
    )
{
    return ( FALSE );
}

# ifndef DBG_IN_DEFINED
inline void 
dbgIn (
    const char *funcName )
{
    dbgPrint ( DBG_TRACE, "Enter '%s()'\n", funcName );
}
/** Define to signal dbgIn() is already defined */
# define DBG_IN_DEFINED
# endif

# ifndef DBG_OUT_DEFINED
inline void 
dbgOut ( 
    const char *funcName )
{
    dbgPrint ( DBG_TRACE, "Leave '%s()'\n", funcName );
}
/** Define to signal dbgOut() is already defined */
# define DBG_OUT_DEFINED
# endif

# ifndef DBG_PRINT_DEFINED
inline void 
dbgPrint (
    const UINT32 _lvl_,
    const char* _str_,
    ... )
{
    ull_time_t t;
    struct tm *tm;
    char str[MAX_LINE_LEN] = { 0 };

    va_list args;
    va_start ( args, _str_ );

    if( dbgMask & _lvl_ ) {

        t = time ( NULL );
        tm = localtime ( &t );
        strftime ( str, sizeof ( str ), "%F %T : ", tm );

        fprintf ( stdout, "%s", str );
        vfprintf (stdout, _str_, args );
        fflush (stdout);
    }

    va_end (args);
}

/** Define to signal dbgPrint() is already defined */
# define DBG_PRINT_DEFINED
# endif

# ifndef DBG_PRINT_BLOCK_DEFINED
inline void 
dbgPrintBlock (
    const UINT32 _lvl_,
    UINT32 _size_, 
    char* _u8ptr_ )
{
    char *_dataPtr_ = _u8ptr_;
    int i;

    int bufSize = _size_ * 3 + _size_ / PRINT_BLOCK_NL_AFTER_BYTE + 3;
    char *buf = malloc ( bufSize );
    size_t cnt = 0;

    cnt = snprintf ( &buf[cnt], bufSize - cnt, "\n" );

    for ( i = 1; i <= _size_; i++, _dataPtr_++) {

        cnt += snprintf ( 
            &buf[cnt], bufSize - cnt, "%02X ", (UINT8) *_dataPtr_ );


        if (((i%PRINT_BLOCK_NL_AFTER_BYTE)==0) && (i>0)) {
            cnt += snprintf ( &buf[cnt], bufSize - cnt, "\n" );
        };
    }

    cnt += snprintf ( &buf[cnt], bufSize - cnt, "\n" );

    dbgPrint ( _lvl_, buf );

    if ( buf ) {
        free ( buf );
    }
}
/** Define to signal dbgPrintBlock() is already defined */
# define DBG_PRINT_BLOCK_DEFINED
# endif

/***************************************************************************
 * 6. END                                                                  *
 ***************************************************************************/

