/***************************************************************************
 *                                                                         *
 * Copyright                                                               *
 *     escrypt GmbH, Bochum, Germany                                       *
 *     Lise-Meitner-Allee 4                                                *
 *     D-44801 Bochum, Germany                                             *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        esc_debug_simple.h

   \brief       Common debug module for simple debugging

   ***

   $Rev: 630 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2017-02-07 08:57:18 +0100 (Di, 07. Feb 2017) $
****************************************************************************/

#ifndef __ESC_DEBUG_SIMPLE_H__
#define __ESC_DEBUG_SIMPLE_H__

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/** Flag to print trace information */
#define DBG_TRACE (1 << 0)
/** Flag to print data */
#define DBG_DATA  (1 << 1)
/** Flag to print information */
#define DBG_INFO  (1 << 2)
/** Flag to print ASN1 XML representation */
#define DBG_ASN1  (1 << 3)
/** Flag to print error messages */
#define DBG_ERR   (1 << 4)

/** Defines after how much printed bytes of a data block a new line is used */
#define PRINT_BLOCK_NL_AFTER_BYTE 16

/** Define string with format specifier to print __FILE__:__LINE__ */ 
#define DBG_FLS "%s:%d "
/** Define arguments for __FILE__:__LINE__ */
#define DBG_FL __FILE__, __LINE__

/***************************************************************************
 * 3. DECLARATIONS                                                         *
 ***************************************************************************/

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. FUNCTION PROTOTYPES                                                  *
 ***************************************************************************/

/**
This function initializes the logging facilities.

\param[in] logLevel 
    Log level that should be used.

\return #BOOL
\retval #FALSE on success
\retval #TRUE  on failure

*/
BOOL 
escInitLogging (
    UINT32 logLevel );

/**
This function closes the logging facilities.
*/
BOOL 
escCloseLogging (
    void );

/**
This function loggs the function name on entry.

\param[in] funcName 
    Name of the function that should be printed.
*/
inline void dbgIn (
    const char *funcName );

/**
This function loggs the function name on exit.

\param[in] funcName 
    Name of the function that should be printed.
*/
inline void dbgOut (
    const char *funcName );

/**
This function loggs the given string.

\param[in] _lvl_ 
    Reference debug level.
    String is logged only if this level is set in the global debug mask.
\param[in] _str_ 
    String to log.
*/
inline void dbgPrint (
    const UINT32 _lvl_,
    const char* _str_, ... ); 

/**
This function loggs the given data block in hex representation.

\param[in] _lvl_ 
    Reference debug level.
    Data is logged only if this level is set in the global debug mask.
\param[in] _size_ 
    Size of the data block.
\param[in] _u8ptr_ 
    Pointer to data.
*/
inline void dbgPrintBlock (
    const UINT32 _lvl_,
    UINT32 _size_, 
    char* _u8ptr_ );

/***************************************************************************
 * 6. MACRO FUNCTIONS                                                      *
 ***************************************************************************/

/***************************************************************************
 * 7. END                                                                  *
 ***************************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* __ESC_DEBUG_SIMPLE_H__ */
