/***************************************************************************
 *                                                                         *
 * Copyright                                                               *
 *     escrypt GmbH, Bochum, Germany                                       *
 *     Lise-Meitner-Allee 4                                                *
 *     D-44801 Bochum, Germany                                             *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        esc_common.h

   \brief       Common include file

   $Rev: 939 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2019-02-21 07:47:21 +0100 (Do, 21. Feb 2019) $
****************************************************************************/

#ifndef __ESC_COMMON_H__
#define __ESC_COMMON_H__

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/** Maximum size of a configuration file line */
#define MAX_CONF_FILE_LINE_LEN 256
/** Short form for faster checking if return code is FAILED */
#define ifNotFailed if ( failed == FALSE )
/** Short form for faster checking if return code is not FAILED */
#define ifFailed if ( failed == TRUE )

/** Maximum size of an ASN1 encoded RSA public key */
#define MAX_ENC_RSA_PUBKEY_SIZE 1024

/***************************************************************************
 * 3. DECLARATIONS                                                         *
 ***************************************************************************/

/* ESCRYPT data types */

/** \internal */
#ifndef ULL_TIME_T_TYPE
/** Flag to signal ULL time_t is defined */
#define ULL_TIME_T_TYPE
    /** ULL time_t data type */
    typedef unsigned long long ull_time_t;
#endif /* !ULL_TIME_T_TYPE */


/** \internal */
#ifndef UINT8_TYPE
/** Flag to signal UINT8 is defined */
#define UINT8_TYPE
/** unsigned 8 bit type */
typedef unsigned char  UINT8;
#endif

/** \internal */
#ifndef UINT16_TYPE
/** Flag to signal UINT16 is defined */
#define UINT16_TYPE
/** unsigned 16 bit type */
typedef unsigned short UINT16;
#endif

/** \internal */
#ifndef UINT32_TYPE
/** Flag to signal UINT32 is defined */
#define UINT32_TYPE
/** unsigned 32 bit type */
typedef unsigned int   UINT32;
#endif

/** \internal */
#ifndef SINT8_TYPE
/** Flag to signal SINT8 is defined */
#define SINT8_TYPE
/** signed 8 bit type */
typedef signed char  SINT8;
#endif

/** \internal */
#ifndef SINT16_TYPE
/** Flag to signal SINT16 is defined */
#define SINT16_TYPE
/** signed 16 bit type */
typedef signed short SINT16;
#endif

/** \internal */
#ifndef SINT32_TYPE
/** Flag to signal SINT32 is defined */
#define SINT32_TYPE
/** signed 32 bit type */
typedef signed int   SINT32;
#endif

/** \internal */
#ifndef BOOL_TYPE
/** Flag to signal BOOL is defined */
#define BOOL_TYPE
/** boolean type */
typedef UINT8 BOOL;
#endif

/** \internal */
#ifndef TRUE_TYPE
/** Flag to signal TRUE is defined */
#define TRUE_TYPE
/** boolean type true */
#ifndef TRUE
#   define TRUE        ((BOOL)1)
#endif

/** \internal */
#ifndef FALSE_TYPE
/** Flag to signal FALSE is defined */
#define FALSE_TYPE
/** boolean type false */
#ifndef FALSE
#   define FALSE       ((BOOL)0)
#endif
#endif
#endif

/** Maximum size of a mapped string */
#define MAX_MAPPED_STR_LEN 24

/** Structure that implements a linked list of strings */
typedef struct strLst {
    /** Pointer to string */
    char *s;
    /** Pointer to next list element */
    struct strLst *next;
} STRING_LIST_s;

/** Lookup table mapping values to strings */
typedef struct {
    /** Lookup value */
    UINT32 val;
    /** Lookup string */
    char str[MAX_MAPPED_STR_LEN];
} STR_LOOKUP_t;

/** Supported hash algorithms enumeration */
typedef enum {
    /** SHA1 ID */
    hash_sha1 = 1,
    /** SHA256 ID */
    hash_sha256
} HASH_t;

/** Enumeration of error codes used at the external DBus interface */
typedef enum {
    /** No error */
    EXT_IF_ERR_NO_ERROR = 0,

    /** checkCert() call successful */
    EXT_IF_ERR_CHECK_CERT_SUCCESS = 10,
    /** pushCert() call successful */
    EXT_IF_ERR_PUSH_CERT_SUCCESS,
    /** pushCrl() call successful */
    EXT_IF_ERR_PUSH_CRL_SUCCESS,
    /** getCrlNextUpd() call successful */
    EXT_IF_ERR_GET_CRL_NEXT_UPD_SUCCESS,

    /** Secure time not available */
    EXT_IF_ERR_SEC_TIME_NOT_AVAILABLE = 20,
    /** Provided data is not a certificate */
    EXT_IF_ERR_NOT_A_CERTIFICATE,
    /** Provided data is not a CRL */
    EXT_IF_ERR_NOT_A_CRL,
    /** PKCS10 CSR was not requested yet */
    EXT_IF_ERR_CSR_NOT_REQUESTED_YET,
    /* UIN file is missing */
    EXT_IF_ERR_UIN_FILE_NOT_AVAILABLE,
    /* Private key is missing */
    EXT_IF_ERR_PRIV_KEY_MISSING,
    /* Private key generation started */
    EXT_IF_ERR_PRIV_KEY_GEN_STARTED,
    /* Private key was already generated */
    EXT_IF_ERR_PRIV_KEY_ALREADY_GENERATED,
    /* CSR generation was successful */
    EXT_IF_ERR_CSR_GENERATION_SUCCESS,

    /** Internal error */
    EXT_IF_ERR_INTERNAL_ERROR = 30,

    /** Certificate is not present */
    EXT_IF_ERR_CERT_NOT_PRESENT = 101,
    /** Certificate is not valid yet */
    EXT_IF_ERR_CERT_NOT_VALID_YET,
    /** Certificate is expired */
    EXT_IF_ERR_CERT_EXPIRED,
    /** Certificate is invalid */
    EXT_IF_ERR_CERT_INVALID,
    /** Certificate is revoked */
    EXT_IF_ERR_CERT_REVOKED,
    /** Certificate is already present */
    EXT_IF_ERR_CERT_ALREADY_PRESENT,
    /** Certificate is replaced */
    EXT_IF_ERR_CERT_REPLACED,
    /** Provided certificate is a root certificate which is not allowed */
    EXT_IF_ERR_CERT_ROOT_NOT_ALLOWED,

    /** CRL is not present */
    EXT_IF_ERR_CRL_NOT_PRESENT = 201,
    /** CRL is not valid yet */
    EXT_IF_ERR_CRL_NOT_VALID_YET,
    /** CRL is expired */
    EXT_IF_ERR_CRL_EXPIRED,
    /** CRL is invalid */
    EXT_IF_ERR_CRL_INVALID,
    /** CRL is already present */
    EXT_IF_ERR_CRL_ALREADY_PRESENT,

    /** Unused error code */
    EXT_IF_ERR_UNUSED
} EXT_IF_ERROR_CODES_t;

/** Structure holding current error state */
typedef struct {
    /** current error code */
    EXT_IF_ERROR_CODES_t err;
    /** error string */
    char *str;
    /** download URL (optional) */
    char *url;
} STATUS_s;

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. FUNCTION PROTOTYPES                                                  *
 ***************************************************************************/

/***************************************************************************
 * 6. MACRO FUNCTIONS                                                      *
 ***************************************************************************/

/***************************************************************************
 * 7. END                                                                  *
 ***************************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* __ESC_COMMON_H__ */
