/***************************************************************************
 *                                                                         *
 * Copyright                                                               *
 *     escrypt GmbH, Bochum, Germany                                       *
 *     Lise-Meitner-Allee 4                                                *
 *     D-44801 Bochum, Germany                                             *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        base64.h

   \brief       Base 64 encoder / decoder header file

   $Rev: 630 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2017-02-07 08:57:18 +0100 (Di, 07. Feb 2017) $
****************************************************************************/

#ifndef __ESC_BASE64_H__
#define __ESC_BASE64_H__

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

/***************************************************************************
 * 3. DECLARATIONS                                                         *
 ***************************************************************************/

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. FUNCTION PROTOTYPES                                                  *
 ***************************************************************************/

/**
This function is used to convert given data to
the representing Base64 encoded string

\param[in] data
    Pointer to data block to convert
\param[in] input_length
    Size of data block to convert

\param[in] output_length
    Size of the resulting Base64 encoded string

\return char*
\retval Base64 encoded string

*/
char *
escBase64Encode(
    const UINT8 *data,
    const UINT32 input_length,
    UINT32 *output_length);


/**
This function is used to decode given PEM data, even if
the Data contains a PEM Header and/or Trailer

\param[in] pem
    Pointer to data block to convert
\param[in] pemSize
    Size of data block to convert

\param[out] decodedData
    Pointer to decoded Data

\param[out] decodedDataSize
    Size of decoded Data

\return BOOL
\retval FALSE for success
\retval TRUE otherwise

*/
BOOL decodePEM(UINT8* pem, UINT32 pemSize,
        UINT8** decodedData, UINT32* decodedDataSize);

/**
This function is used to convert given Base64 encoded string to
representing byte array

\param[in] data
    Pointer to Base64 encoded string
\param[in] input_length
    Size of Base64 encoded string

\param[out] output_length
    Pointer where size of resulting byte array is stored

\return char*
\retval Byte array containing resulting data

*/
UINT8 *
escBase64Decode(
    const UINT8* data,
    const UINT32 input_length,
    UINT32 *output_length);

/**
This function creates the decoding table used for Base64 operations.

\return none
*/
void
build_decoding_table();

/**
This function frees all structures used by Base64 operations,
e.g. the decoding table.

\return none
*/
void
base64_cleanup();

/***************************************************************************
 * 6. MACRO FUNCTIONS                                                      *
 ***************************************************************************/

/***************************************************************************
 * 7. END                                                                  *
 ***************************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* __ESC_BASE64_H__ */
