/***************************************************************************
 *                                                                         *
 * Copyright                                                               *
 *     escrypt GmbH, Bochum, Germany                                       *
 *     Lise-Meitner-Allee 4                                                *
 *     D-44801 Bochum, Germany                                             *
 *                                                                         *
 *     http://www.escrypt.com                                              *
 *     info"at"escrypt.com                                                 *
 *                                                                         *
 * All Rights reserved                                                     *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************/
/*!
   \file        cmp.h

   \brief       Main module of CMP library

   ***

   $Rev: 780 $
 */
/***************************************************************************
$Author: mlange $
$Date: 2017-07-28 15:40:59 +0200 (Fr, 28. Jul 2017) $
****************************************************************************/

#ifndef __CMP_H__
#define __CMP_H__

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 * 1. INCLUDES                                                             *
 ***************************************************************************/

#include "../asn1-2005-multi-file-os-asn1c/Certificate.h"
#include "../../common/inc/esc_common.h"
#include "../asn1-2005-multi-file-os-asn1c/PKIMessage.h"
//#include "PKIMessage.h"

/***************************************************************************
 * 2. DEFINES                                                              *
 ***************************************************************************/

#if defined ( UNIT_TESTING )
/** Flag to signal storage of the certificate(s) */
#define CMP_FLAG_STORE_CERTS                   0x00000001
/** Flag to signal certificate updating */
#define CMP_FLAG_STORE_CERTS_UPDATE            0x00000020
/** Flag to signal outstanding certificate confirm */
#define CMP_FLAG_CONFIRM_RECEIPTION            0x00001000
/** Flag to signal outstanding certificate confirm using the previous device key */
#define CMP_FLAG_CONFIRM_RECEIPTION_PREV_KEY   0x00004000
#endif /* UNIT_TESTING */

/** Maximum size of an certificate */
#define MAX_CERT_SIZE 2048

/** Certificate ID enumeration */
typedef enum {
    /** ID none */
    cert_id_none = 0,
    /** Device certificate ID */
    cert_id_device,
    cert_id_endpoint,
    cert_id_issuer,
    cert_id_root,
} CERT_ID_e;

/** Certificate list structure */
typedef struct certList {
    /** Certificates current error code */
    EXT_IF_ERROR_CODES_t err;
    /** Flag to signal if certificate is part of the device chain */
    BOOL devChain;
    /** Flag to signal if certificate is verified successfully */
    BOOL validSignature;
    /** Flag signaling if the certificates time stamps are valid */
    BOOL validTimestamps;
    /** Flag signaling if the certificates issuer is available */
    BOOL issuerAvailable;
    /** Flag to signal if certificate needs to be renewed  */
    BOOL renew;
    /** Flag to signal certificate must be stored */
    BOOL store;
    /** Flag to signal certificate must be considered as trust anchor for
        TLS connections */
    BOOL tlsTrust;
    /** Certificates file name */
    char *fileName;
    /** Certificate ID */
    CERT_ID_e certId;
    /** Certificate title */
    char *title;
    /** Pointer to subject CN */
    char *subjectCn;
    /** Pointer to issuer CN */
    char *issuerCn;
    /** Pointer where the encoded certificate data is stored */
    UINT8 *certPtr;
    /** Size of the encoded certificate */
    UINT32 certSize;
    /** Pointer to decoded certificate */
    Certificate_t *crt;
    /** Pointer to next list element */
    struct certList *next;
    /** URI of corresponding CRL */
    char* crlUri;
    /** Time stamp valid not before */
    ull_time_t validNotBefore;
    /** Time stamp valid not after */
    ull_time_t validNotAfter;
} CERT_LIST_s;


/** CMP data structure */
typedef struct {
    /** Pointer to PKCS1 encoded device public key */
    UINT8 *pkcs1PubKey;
    /** Size of PKCS1 encoded device public key */
    UINT32 pkcs1PubKeySize;
    /** Pointer to certificate list */
    CERT_LIST_s *certList;
    /** Pointer to device unique ID */
    char *deviceUniqueId;
    /** Issuer CN with optional wildcards **/
    char* issuerCN;
    /** List that hold titles of mandatory certificates */
    STRING_LIST_s *mandCrtTitles;
    /** Flag if Issuer CN shall be verified **/
    BOOL verifyIssuer;
    /** Key size ID */
    UINT32 keySize;
    /** Pointer to unique ID source name */
    char *uniqueIdSrc;
#ifdef UNIT_TESTING
    /** Pointer to device key pair structure */
    void* keyPair;
    /** Certificate refresh threshold */
    UINT32 certRefreshThreshold;
    /** CMP flags */
    UINT32 flags;
#endif /* UNIT_TESTING */
} CMP_DATA_s;


/***************************************************************************
 * 3. DECLARATIONS                                                         *
 ***************************************************************************/

/***************************************************************************
 * 4. CONSTANTS                                                            *
 ***************************************************************************/

/***************************************************************************
 * 5. FUNCTION PROTOTYPES                                                  *
 ***************************************************************************/

/***************************************************************************
 * 6. MACRO FUNCTIONS                                                      *
 ***************************************************************************/

/***************************************************************************
 * 7. END                                                                  *
 ***************************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* __CMP_H__ */
