/******************************************************************
 *FILE: UserEncryptDecrypt_Notifier.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UserEncryptDecrypt
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Guilherme Ferreira  (guilhermedaniel.ferreira@altran.com)
 * @date Jan, 2018
 */

#ifndef SRC_UPGRADE_USERENCRYPTDECRYPT_NOTIFIER_H_
#define SRC_UPGRADE_USERENCRYPTDECRYPT_NOTIFIER_H_

#include <list>

#include "upgrade/UserEncryptDecrypt_ConversionProcess.h"

class Notifier {
 public:
  /**
   * @brief Constructor for the class.
   */
  Notifier();

  /**
   * @brief Destructor for the class.
   */
  virtual ~Notifier();

  /**
   * @brief Calling this function adds an observer to the list of observers to
   * notify.
   */
  void addObserver(ConversionProcess::Observer& observer);

  /**
   * @brief Calling this function removes an observer to the list of observers
   * to notify.
   */
  void removeObserver(ConversionProcess::Observer& observer);

  /**
   * @brief Calling this function calls the onUpgrade method from all of the
   * observers.
   */
  void notifyAllObservers();

 private:
  std::list<ConversionProcess::Observer*> _observerList;
};

#endif /* SRC_UPGRADE_USERENCRYPTDECRYPT_NOTIFIER_H_ */
