/******************************************************************
 *FILE: UserEncryptDecrypt_AuthenticationConvert.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UserEncryptDecrypt
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author José Oliveira  (josearmando.oliveira@altran.com)
 * @date Jan, 2018
 */

#ifndef USERENCRYPTDECRYPT_AUTHENTICATIONCONVERT_H
#define USERENCRYPTDECRYPT_AUTHENTICATIONCONVERT_H

#include <core/authentication/UserEncryptDecrypt_AuthenticationDatabase.h>
#include "UserEncryptDecrypt_IConvert.h"

/**
 * This class implements the IConvert 'interface' and provides methods to
 * convert Authentication data from a previous version to a recent one.
 */
class AuthenticationConvert : public IConvert {
 public:
  /**
     * @brief This function converts the provided data to the previously
   * provided destination version.
     *
     * @param data this parameter is not used in this case, any value can be
   * passed
     * @param sourceVersion is the current version of the system.
     * @param destinationVersion is the version the data needs to be upgraded
   * to.
     *
     * @return returns the upgraded data.
     */
  std::vector<unsigned char> convertData(std::vector<unsigned char> data,
                                         int sourceVersion,
                                         int destinationVersion) override;
  /**
   * @brief This function initiates the class parameters.
   */
  void init();

  /**
    * @brief Swaps the Authentication Databases to the new versions
    */
  static void end();

  /**
    * @brief Returns an instance of Converter.
    */
  static std::shared_ptr<AuthenticationConvert> getConverter();

 private:
  std::map<int, std::map<int, std::function<std::vector<unsigned char>(
                                  std::vector<unsigned char>)>>>
      _mapAuthenticationDatabaseFunction;

  static std::vector<unsigned char> v0v1(std::vector<unsigned char>);

  static std::string createMUKv0v1(unsigned int uid);

  AuthenticationConvert();

  static std::shared_ptr<AuthenticationConvert> _instance;

  static std::mutex _mutex;

  std::string toSave;
};

#endif  // USERENCRYPTDECRYPT_AUTHENTICATIONCONVERT_H
