/******************************************************************
 *FILE: UserEncryptDecrypt_UEDPacketDataTypeDomain.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UEDPacketDataTypeDomain
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Artur Bento  (artur.bento@altran.com)
 * @date Fev, 2018
 */

#ifndef USERENCRYPTDECRYPT_UEDPACKETDATATYPEDOMAIN_H
#define USERENCRYPTDECRYPT_UEDPACKETDATATYPEDOMAIN_H

#ifndef ROBS
#include <boost/property_tree/json_parser.hpp>
#include <boost/property_tree/ptree.hpp>
#else
#include <mock/RobsMock.h>
#endif

#include <string>
#include "UserEncryptDecrypt_IDomain.h"
#include "UserEncryptDecrypt_PacketStringDomain.h"
#include "UserEncryptDecrypt_Utils.h"
#include "error/UserEncryptDecrypt_ErrorMessage.h"

/**
 * Class to ensure the robustness of a base64 string format
 */
class TokenDomain : public std::string {
 public:
  TokenDomain(const std::string& string) : std::string(string){};
};

/**
 * This function validate if a UEDPacket has Token as dataType.
 */
template <>
void isValidInDomain<TokenDomain>(const TokenDomain& tokenStr) throw(
    ErrorMessage) {
  isValidInDomain<PacketString>(tokenStr);

  int endPos               = tokenStr.find(".");
  std::string packetHeader = tokenStr.substr(0, endPos);

  std::vector<unsigned char> decHeader = base64_decode(packetHeader);
  std::stringstream ssHeader(std::string(decHeader.begin(), decHeader.end()));
  bptree::ptree ptHeader;
  try {
    bptree::read_json(ssHeader, ptHeader);
  } catch (boost::property_tree::json_parser_error&) {
    THROW_UED_EXCEPTION(ErrType::PCKT_InvalidFormat);
  }

  std::string typValue;
  std::string algValue;
  try {
    typValue = ptHeader.get<std::string>("typ");
  } catch (boost::property_tree::ptree_error& e) {
    THROW_UED_EXCEPTION(ErrType::PCKT_InvalidTokenFormat);
  }

  try {
    algValue = ptHeader.get<std::string>("alg");
  } catch (boost::property_tree::ptree_error& e) {
    THROW_UED_EXCEPTION(ErrType::PCKT_InvalidTokenFormat);
  }

  if (typValue != "userToken" || algValue != "HS256") {
    THROW_UED_EXCEPTION(ErrType::VERSION_notCompatible);
  }
}

#endif  // USERENCRYPTDECRYPT_UEDPACKETDATATYPEDOMAIN_H
