/******************************************************************
 *FILE: UserEncryptDecrypt_PlainDataDomain.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UEDPacket
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author José Oliveira  (josearmando.oliveira@altran.com)
 * @date Fev, 2018
 */

#ifndef USERENCRYPTDECRYPT_USERENCRYPTDECRYPT_PLAINDATADOMAIN_H
#define USERENCRYPTDECRYPT_USERENCRYPTDECRYPT_PLAINDATADOMAIN_H

#include <domains/UserEncryptDecrypt_IDomain.h>
#include <error/UserEncryptDecrypt_ErrorMessage.h>
#include <vector>

/**
 * Class to ensure the robustness of a PlainData format
 */
class PlainData : public std::vector<unsigned char> {
 public:
  PlainData(const std::vector<unsigned char>& data)
      : std::vector<unsigned char>(data){};
};

/**
 * This function validate if PlainData is valid in its defined domain.
 */
template <>
void isValidInDomain<PlainData>(const PlainData& d) throw(ErrorMessage) {
  std::vector<unsigned char> data = d;

  if (data.empty()) {
    THROW_UED_EXCEPTION(ErrType::DOMAIN_plainDataEmpty);
  }
}

#endif  // USERENCRYPTDECRYPT_USERENCRYPTDECRYPT_PLAINDATADOMAIN_H
