/******************************************************************
 *FILE: UserEncryptDecrypt_PassphraseDomain.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UEDPacket
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author José Oliveira  (josearmando.oliveira@altran.com)
 * @date Fev, 2018
 */

#ifndef USERENCRYPTDECRYPT_PASSPHRASEDOMAIN_H
#define USERENCRYPTDECRYPT_PASSPHRASEDOMAIN_H

#include <error/UserEncryptDecrypt_ErrorMessage.h>
#include <sys/stat.h>
#include <memory>
#include <vector>
#include "UserEncryptDecrypt_IDomain.h"
#include "backends/UserEncryptDecrypt_BackendManager.h"
#include "backends/sdc/UserEncryptDecrypt_SDCBackend.h"

/**
 * Class to ensure the robustness of Passphrase format
 */
class Passphrase : public std::vector<unsigned char> {
 public:
  Passphrase(const std::vector<unsigned char>& data)
      : std::vector<unsigned char>(data){};
};

/**
 * This function validate if a Passphrase is valid in its defined domain.
 */
template <>
void isValidInDomain<Passphrase>(const Passphrase& d) throw(ErrorMessage) {
  std::vector<unsigned char> data = d;
  std::shared_ptr<SDCBackend> sdcBackend =
      BackendManager::getInstance()->get<SDCBackend>();

  if (data.empty() || data.size() < 4 ||
      data.size() > std::numeric_limits<int>::max()) {
    sdcBackend->Overwrite(data);
    THROW_UED_EXCEPTION(ErrType::AUTH_PassphraseNotValid);
  }
  sdcBackend->Overwrite(data);
}

#endif  // USERENCRYPTDECRYPT_PASSPHRASEDOMAIN_H
