/******************************************************************
<<<<<<< HEAD
 *FILE: UserEncryptDecrypt_PacketStringDomain.h
=======
 *FILE: PacketStringDomain.h
>>>>>>> develop
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: PacketStringDomain
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Artur Bento  (artur.bento@altran.com)
 * @date Fev, 2018
 */

#ifndef USERENCRYPTDECRYPT_PACKETSTRINGDOMAIN_H
#define USERENCRYPTDECRYPT_PACKETSTRINGDOMAIN_H

#ifndef ROBS
#include <boost/property_tree/json_parser.hpp>
#include <boost/property_tree/ptree.hpp>
#else
#include <mock/RobsMock.h>
#endif
#include <string>
#include "UserEncryptDecrypt_Base64Domain.h"
#include "UserEncryptDecrypt_IDomain.h"
#include "UserEncryptDecrypt_Utils.h"
#include "error/UserEncryptDecrypt_ErrorMessage.h"

namespace bptree = boost::property_tree;

/**
 * Class to ensure the robustness of Packet in string format
 */
class PacketString : public std::string {
 public:
  PacketString(const std::string& string) : std::string(string){};
};

/**
 * This function validate if the Packet in string format is correct.
 * First the packet parts is verified, they can'b be less and more than tree.
 * The second validation is to each part, checking if each one is in base64
 * format.
 *
 * In case of string format of packet changes this function need to be modified
 * (eg. structure).
 */
template <>
void isValidInDomain<PacketString>(const PacketString& d) throw(ErrorMessage) {
  std::vector<std::string> packetParts;
  std::istringstream f(d);
  std::string s;
  while (getline(f, s, '.')) {
    if (packetParts.size() < packetParts.capacity()) {
      packetParts.push_back(s);
    } else {
      try {
        packetParts.push_back(s);
      } catch (std::bad_alloc&) {
        THROW_UED_EXCEPTION(ErrType::SYSTEM_noMemory);
      }
    }
  }

  if (packetParts.size() != 3) {
    THROW_UED_EXCEPTION(ErrType::PCKT_InvalidFormat);
  }

  for (auto part : packetParts) {
    isValidInDomain<Base64>(part);
  }

  std::vector<unsigned char> decSignature = base64_decode(packetParts[2]);
  std::stringstream ssSignature(
      std::string(decSignature.begin(), decSignature.end()));
  bptree::ptree ptSignature;
  try {
    bptree::read_json(ssSignature, ptSignature);
  } catch (boost::property_tree::json_parser_error&) {
    THROW_UED_EXCEPTION(ErrType::PCKT_InvalidFormat);
  }

  try {
    std::string sigHeaderValue  = ptSignature.get<std::string>("sigHeader");
    std::string sigPayloadValue = ptSignature.get<std::string>("sigPayload");
  } catch (boost::property_tree::ptree_error& e) {
    THROW_UED_EXCEPTION(ErrType::PCKT_SignatureNotFound);
  }
}
#endif  // USERENCRYPTDECRYPT_PACKETSTRINGDOMAIN_H
