/******************************************************************
 *FILE: UserEncryptDecrypt_FilenameDomain.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UEDPacket
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Guilherme Ferreira  (guilhermedaniel.ferreira@altran.com)
 * @date Fev, 2018
 */

#ifndef USERENCRYPTDECRYPT_FILENAMEDOMAIN_H
#define USERENCRYPTDECRYPT_FILENAMEDOMAIN_H

#include <error/UserEncryptDecrypt_ErrorMessage.h>
#include <sys/stat.h>
#include <string>
#include "UserEncryptDecrypt_IDomain.h"

/**
 * Class to ensure the robustness of a Filename string format
 */
class Filename : public std::string {
 public:
  Filename(const std::string& string) : std::string(string){};
};

/**
 * This function validate if a Filename has valid domain.
 */
template <>
void isValidInDomain<Filename>(const Filename& d) throw(ErrorMessage) {
  std::string data = d;

  if (data.empty() || data == "") {
    THROW_UED_EXCEPTION(ErrType::CONSISTENT_filenameNotValid);
  }

  if (data.find_last_of('/', 0) != std::string::npos) {
    std::string filePath;
    try {
      filePath = data.substr(0, data.find_last_of('/', 0));
    } catch (std::bad_alloc&) {
      THROW_UED_EXCEPTION(ErrType::SYSTEM_noMemory);
    } catch (std::out_of_range&) {
      THROW_UED_EXCEPTION(ErrType::CONSISTENT_filenameNotValid);
    }

    struct stat myFile;
    if (stat(filePath.c_str(), &myFile) != 0) {
      THROW_UED_EXCEPTION(ErrType::CONSISTENT_filenameNotValid);
    } else if (!S_ISDIR(myFile.st_mode) != 0) {
      THROW_UED_EXCEPTION(ErrType::CONSISTENT_filenameNotValid);
    }
  }
}

#endif  // USERENCRYPTDECRYPT_FILENAMEDOMAIN_H
