/******************************************************************
 *FILE: Base64Domain.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: Base64Domain
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Artur Bento  (artur.bento@altran.com)
 * @date Fev, 2018
 */

#ifndef USERENCRYPTDECRYPT_BASE64DOMAIN_H
#define USERENCRYPTDECRYPT_BASE64DOMAIN_H

#include <error/UserEncryptDecrypt_ErrorMessage.h>
#include <regex>
#include <string>
#include "UserEncryptDecrypt_IDomain.h"

/**
 * Class to ensure the robustness of a base64 string format
 */
class Base64 : public std::string {
 public:
  Base64(const std::string& string) : std::string(string){};
};

/**
 * This function validate if a string is in base64 format.
 */
template <>
void isValidInDomain<Base64>(const Base64& d) throw(ErrorMessage) {
  if (!std::regex_match(
          d, std::regex("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/"
                        "]{3}=|[A-Za-z0-9+/]{2}==)$"))) {
    THROW_UED_EXCEPTION(ErrType::DOMAIN_InvalidBase64Format);
  }
}
#endif  // USERENCRYPTDECRYPT_BASE64DOMAIN_H
