/******************************************************************
 *FILE: UserEncryptDecrypt_Token.cpp
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UserEncryptDecrypt
 *COPYRIGHT: © 2017 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author José Oliveira  (josearmando.oliveira@altran.com)
 * @date Dec, 2017
 */

#include "UserEncryptDecrypt_Token.h"
#include "domains/UserEncryptDecrypt_TokenDomain.h"
#include "domains/UserEncryptDecrypt_UserIDDomain.h"

std::string Token::_typStr    = "typ";
std::string Token::_algStr    = "alg";
std::string Token::_userIDStr = "userID";

Token::Token() : Packet(true), _userID(boost::none) {}
Token::Token(unsigned int userID) : Packet(true), _userID(userID) {}
Token::~Token() {}

void Token::buildToken() {
  _header.addField(_typStr, "userToken");
  _header.addField(_algStr, "HS256");
  if (_userID != boost::none) {
    isValidInDomain<UserID>(_userID.get());
    _payload.addField(_userIDStr, _userID.get());
  }
}

boost::optional<unsigned int> Token::getUserID() {
  return _payload.getField<unsigned int>(_userIDStr);
}

std::string Token::encode() {
  buildToken();
  return Packet::encode();
}

bool Token::decode(std::string str) {
  isValidInDomain<TokenDomain>(str);

  return Packet::decode(str);
}

bool Token::isValid() {
  bool validPacket                     = Packet::isValid();
  boost::optional<unsigned int> userID = getUserID();
  boost::optional<std::string> algStr  = _header.getField<std::string>(_algStr);
  boost::optional<std::string> typStr  = _header.getField<std::string>(_typStr);

  return (validPacket && algStr != boost::none && typStr != boost::none &&
          !algStr.get().empty() && !typStr.get().empty() &&
          (userID != boost::none));
}
