/******************************************************************
 *FILE: UserEncryptDecrypt_Packet.cpp
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: Packet
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Artur Bento  (artur.bento@altran.com)
 * @date Jan, 2018
 */

#include "UserEncryptDecrypt_Packet.h"
#include <iostream>
#include <vector>
#include "UserEncryptDecrypt_PacketSignature.h"
#include "domains/UserEncryptDecrypt_PacketStringDomain.h"

Packet::Packet(bool encryptPayload)
    : _encryptPayload(encryptPayload), _isValid(false) {}
Packet::~Packet() {}

std::string Packet::encode() throw(ErrorMessage) {
  PacketSignature signature(_header, _payload);
  std::string payload = "";

  if (_encryptPayload) {
    payload = _payload.encode();
  } else {
    payload = _payload.encodeB64();
  }
  return _header.encode() + '.' + payload + '.' + signature.encode();
}

bool Packet::decode(std::string str) throw(ErrorMessage) {
  isValidInDomain<PacketString>(str);

  std::vector<std::string> tkParts;
  std::istringstream f(str);
  std::string s;
  while (getline(f, s, '.')) {
    if (tkParts.size() < tkParts.capacity()) {
      tkParts.push_back(s);
    } else {
      try {
        tkParts.push_back(s);
      } catch (std::bad_alloc&) {
        THROW_UED_EXCEPTION(ErrType::SYSTEM_noMemory);
      }
    }
  }
  _header = PacketHeader();
  _header.decode(tkParts[0]);

  _payload = PacketPayload();
  if (_encryptPayload) {
    _payload.decode(tkParts[1]);
  } else {
    _payload.decodeB64(tkParts[1]);
  }

  PacketSignature signature = PacketSignature();
  signature.decode(tkParts[2]);

  _isValid = signature.verifySignature(_header, _payload);

  return _isValid;
}

bool Packet::isValid() { return _isValid; }
