/******************************************************************
 *FILE: UserEncryptDecrypt_Application.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: Application emulation
 *COPYRIGHT: © 2017 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Ulisses Costa (marioulisses.costa@altran.com)
 * @date Dec, 2017
 */

#ifndef SRC_CORE_USERENCRYPTDECRYPT_APPLICATION_H_
#define SRC_CORE_USERENCRYPTDECRYPT_APPLICATION_H_

/**
 * This class is an static class to start and stop the UserEncryptDecrypt
 * logging system.
 */
class Application {
 public:
  /**
   * @brief Destructor for the class.
   */
  virtual ~Application();
  /**
   * @brief start the UserEncryptDecrypt logging system, registering it in the
   * DLT Viewer
   */
  static void startApplication();
  /**
   * @brief end the UserEncryptDecrypt logging system, removing the application
   * from the DLT Viewer
   */
  static void stopApplication();

 private:
  Application();
};

#endif /* SRC_CORE_USERENCRYPTDECRYPT_APPLICATION_H_ */
