/******************************************************************
 *FILE: UserEncryptDecrypt_Version.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UserEncryptDecrypt
 *COPYRIGHT: © 2018 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author Guilherme Ferreira  (guilhermedaniel.ferreira@altran.com)
 * @date Jan, 2018
 */

#ifndef SRC_USERENCRYPTDECRYPT_VERSION_H_
#define SRC_USERENCRYPTDECRYPT_VERSION_H_

/**
 * @brief Checks if the inputed values can be converted to a version
 *
 * @param a
 * @param b
 *
 * @return the converted version
 */
static unsigned int checkIfCanCreateVersion(uint8_t a, uint8_t b) {
  if (((uint16_t)a) < UINT8_MAX && ((uint16_t)b) < UINT8_MAX) {
    return (((a) << 8) + (b));
  }
  return 0;
}

/**
 * @brief Checks if the inputed values can be converted to a version
 *
 * @param a
 * @param b
 * @param c
 *
 * @return the converted version
 */
static unsigned int checkIfCanCreateVersion(uint8_t a, uint8_t b, uint8_t c) {
  if (((uint16_t)a) < UINT8_MAX && ((uint16_t)b) < UINT8_MAX &&
      ((uint16_t)c) < UINT8_MAX) {
    return (((a) << 16) + (b << 8) + c);
  }
  return 0;
}

#define UED_MIN_COMPAT_VERSION UED_VERSION(1, 0, 0)

#define UED_MAJOR 1
#define UED_MINOR 3
#define UED_REVISION 0

#define UED_VERSION(a, b, c) checkIfCanCreateVersion(a, b, c)
#define UED_CURRENT_VERSION UED_VERSION(UED_MAJOR, UED_MINOR, UED_REVISION)

#define UED_HEADER_MAJOR 1
#define UED_HEADER_MINOR 0

#define UED_HEADER_VERSION(a, b) checkIfCanCreateVersion(a, b)
#define UED_HEADER_CURRENT_VERSION \
  UED_HEADER_VERSION(UED_HEADER_MAJOR, UED_HEADER_MINOR)

#endif /* SRC_USERENCRYPTDECRYPT_VERSION_H_ */
