/******************************************************************
 *FILE: UserEncryptDecrypt_Diagnosis.h
 *SW-COMPONENT: UserEncryptDecrypt
 *DESCRIPTION: UserEncryptDecrypt
 *COPYRIGHT: © 2017 Robert Bosch GmbH
 *
 *The reproduction, distribution and utilization of this file as
 *well as the communication of its contents to others without express
 *authorization is prohibited. Offenders will be held liable for the
 *payment of damages. All rights reserved in the event of the grant
 *of a patent, utility model or design.
 ******************************************************************/
/**
 * @author José Oliveira  (josearmando.oliveira@altran.com)
 * @date Dec, 2017
 *
 * Date      | Author             | Modification
 * 14/08/2018| AKM7COB			  | changed class name logger to logger1. class name logger is already used in ASF framework
 */

#ifndef USERENCRYPTDECRYPT_DIAGNOSIS_H
#define USERENCRYPTDECRYPT_DIAGNOSIS_H

#include <core/logger/UserEncryptDecrypt_Logger.h>
#include <memory>

class Diagnosis {
 public:
  /**
   *  @brief Reset to default state (factory state).
   */
  static void resetToFactory();

  virtual ~Diagnosis();

 private:
  Diagnosis();

  std::shared_ptr<Logger1> _logger;
  std::shared_ptr<LogContext> _ctx;

  static std::shared_ptr<Diagnosis> _instance;
  static std::mutex _mutex;

  static std::shared_ptr<Diagnosis> getInstance();
};

#endif  // USERENCRYPTDECRYPT_DIAGNOSIS_H
