/*
 * Timer.h
 *
 *  Created on: Jul 21, 2017
 *      Author: mhk6kor
 */

#ifndef TIMER_H_
#define TIMER_H_
#include <stdio.h>
#include <stdint.h>
#include <stdbool.h>
#include <time.h>

#ifdef __cplusplus
extern "C"{
#endif

typedef struct tm date_time;
typedef unsigned long long ull_time_t;

#define SECSPERDAY (86400UL) /* == ( 24 * 60 * 60) */
#define SECSPERHOUR (3600UL) /* == ( 60 * 60) */
#define SECSPERMIN (60UL) /* == ( 60) */

#define LEAPYEAR(year)          (!((year) % 4) && (((year) % 100) || !((year) % 400)))


/*moved to c file as per mirko requirements*/
/*const int _ytab[2][12] = {
{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};
*/

/**
The bschgmtime function converts the time stamp pointed to by timer into broken-down time,
expressed as UTC
bschgmtime function takes pointer to uint64_t and returns a pointer to Struct tm broken time
the values written are in format of struct tm. 
It takes epoch values.
Unix time (also known as POSIX time or epoch time) is a system for describing instants in time, 
defined as the number of seconds that have elapsed since 00:00:00 Coordinated Universal Time (UTC), 
Thursday, 1 January 1970, minus the number of leap seconds that have taken place since then.  
*/

date_time *bschgmtime(const ull_time_t *timer);

date_time bschgmtime_sub(ull_time_t timer);

date_time *bschgmtime_r(const ull_time_t *timeval, date_time *result);

/*
This function 'compiles' the elements of a broken-down time structure, returning a binary time stamp.
The elements of timeptr are interpreted as representing Time.
timeptr points to the struct tm
	   struct tm {
   	   int tm_sec;          seconds,  range 0 to 59
   	   int tm_min;          minutes, range 0 to 59
   	   int tm_hour;         hours, range 0 to 23
   	   int tm_mday;         day of the month, range 1 to 31
   	   int tm_mon;          month, range 0 to 11
   	   int tm_year;         The number of years since 1900
   	   int tm_wday;         day of the week, range 0 to 6
   	   int tm_yday;         day in the year, range 0 to 365
   	   int tm_isdst;        daylight saving time
};*/

ull_time_t bschmktime(date_time *timeptr);


#ifdef __cplusplus
}
#endif
#endif /* TIMER_H_ */
