/*
 * Timer.c
 *
 *  Created on: Jul 21, 2017
 *      Author: mhk6kor
 *	Resolved PSARCC30-4898	
 */



#include "Timer.h"


const int _ytab[2][12] = {
{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
};


/************************************************************************
 *
 * FUNCTION:bschgmtime
 *
 * DESCRIPTION: Function to convert epoch value to  date and time values.
 *
 * PARAMETER: const ull_time_t *timer
 *
 * RETURNVALUE: reference to date_time struct
 *
 *************************************************************************/
date_time *bschgmtime(const ull_time_t *timer)
{
	static date_time s_date_time={0};
	date_time *tp=&s_date_time;

	int64_t  seconds, minutes, hours, days, year, month;
	uint32_t dayOfWeek,yday,dim;

	if(NULL ==timer)
	{
		return tp;// invalid value to convert
	}
	seconds = *timer;

	/* calculate minutes */
	minutes  = seconds / 60;
	seconds -= minutes * 60;
	/* calculate hours */
	hours    = minutes / 60;
	minutes -= hours   * 60;
	/* calculate days */
	days     = hours   / 24;
	hours   -= days    * 24;

	//cout<<days<<endl;
	/* Unix time starts in 1970 on a Thursday */
	year      = 1970;
	dayOfWeek = 4;

	while(1)
	{
		bool leapYear   = LEAPYEAR(year);
		int  daysInYear = leapYear ? 366 : 365;
		if (days >= daysInYear)
		{
			dayOfWeek += leapYear ? 2 : 1;
			days      -= daysInYear;
			if (dayOfWeek >= 7)
				dayOfWeek -= 7;
			++year;
		}
		else
		{
			yday = days;
			dayOfWeek  += days;
			dayOfWeek  %= 7;


			for(month = 0; month < 12; ++month)
			{
				int  daysInMonth=0;

				/* add a day to feburary if this is a leap year */
				if (month == 1 && leapYear)
					daysInMonth=1;

				dim =_ytab[daysInMonth][month];

				if (days >= dim)
					days -= dim;

				else
					break;
			}
			break;
		}
	}


	tp->tm_sec = seconds;
	tp->tm_min = minutes;
	tp->tm_hour = hours;
	tp->tm_mday=days+1; //1-31
	tp->tm_mon=month;
	tp->tm_year=year-1900;
	tp->tm_isdst=0;
	tp->tm_wday=dayOfWeek;
	tp->tm_yday=yday;
	return tp;
}

/************************************************************************
 *
 * FUNCTION: bschgmtime_sub
 *
 * DESCRIPTION: Function to convert epoch value to  date and time values.
 *
 * PARAMETER: ull_time_t timer
 *
 * RETURNVALUE: date_time struct
 *
 *************************************************************************/
date_time bschgmtime_sub(ull_time_t timer)
{
		date_time cp_date_time={0};
		//date_time *tp=&s_date_time;

		int64_t  seconds, minutes, hours, days, year, month;
		uint32_t dayOfWeek,yday,dim;
		seconds = timer;

		/* calculate minutes */
		minutes  = seconds / 60;
		seconds -= minutes * 60;
		/* calculate hours */
		hours    = minutes / 60;
		minutes -= hours   * 60;
		/* calculate days */
		days     = hours   / 24;
		hours   -= days    * 24;

		//cout<<days<<endl;
		/* Unix time starts in 1970 on a Thursday */
		year      = 1970;
		dayOfWeek = 4;

		while(1)
		{
			bool leapYear   = LEAPYEAR(year);
			int  daysInYear = leapYear ? 366 : 365;
			if (days >= daysInYear)
			{
				dayOfWeek += leapYear ? 2 : 1;
				days      -= daysInYear;
				if (dayOfWeek >= 7)
				  dayOfWeek -= 7;
				++year;
			}
			else
			{
				 yday = days;
				 dayOfWeek  += days;
				 dayOfWeek  %= 7;

				/* calculate the month and day */
			
				for(month = 0; month < 12; ++month)
				{
					int  daysInMonth=0;

					/* add a day to feburary if this is a leap year */
					if (month == 1 && leapYear)
			            daysInMonth=1;
				
					dim =_ytab[daysInMonth][month];

					if (days >= dim)
						days -= dim;

					else
						break;

				}
				break;
			}
		}

		cp_date_time.tm_sec = seconds;
		cp_date_time.tm_min = minutes;
		cp_date_time.tm_hour = hours;
		cp_date_time.tm_mday=days+1; //1-31
		cp_date_time.tm_mon=month;
		cp_date_time.tm_year=year-1900;
		cp_date_time.tm_isdst=0;
		cp_date_time.tm_wday=dayOfWeek;
		cp_date_time.tm_yday=yday;
		
		return cp_date_time;
}


/************************************************************************
 *
 * FUNCTION: ull_time_t bschmktime(date_time *timeptr)
 *
 * DESCRIPTION: Function to convert date and time values to epoch value
 *
 * PARAMETER: date_time *timeptr
 *
 * RETURNVALUE: ull_time_t
 *
 *************************************************************************/
ull_time_t bschmktime(date_time *timeptr)
{
	ull_time_t epoch=1970; // epoch year
	ull_time_t secs = 0;
	int countleap = 0;
	int i;
	int dayspermonth;
	
	if(NULL!=timeptr)
	{

	int year=timeptr->tm_year-70;
	int mon=timeptr->tm_mon;

	/**total secs after 1970**/
	secs = (ull_time_t)year * (SECSPERDAY * 365);
	for (i = 0; i < year; i++)
	{
		if (LEAPYEAR((epoch + i)))
			countleap++;
	}
	/**total secs including leap years= total secs + total number of leapdays*secs **/
	secs += (countleap * SECSPERDAY);

	/**total secs including leap years= total secs + current days secs/min/hour/ previous day **/
	secs += timeptr->tm_sec;
	secs += (timeptr->tm_hour * SECSPERHOUR);
	secs += (timeptr->tm_min * SECSPERMIN);
	secs += ((timeptr->tm_mday - 1) * SECSPERDAY);


	/** only if Month is gretaer than January - calculaye elapsed months secs value  **/
	if (mon > 0)
	{
		dayspermonth = 0;

		if (LEAPYEAR((epoch + year))) // Only counts when we're on leap day or past it
		{
			if (mon > 1)
			{
				dayspermonth = 1;
			} else if (mon == 1 && timeptr->tm_mday >= 29) {
				dayspermonth = 1;
			}
		}

		for (i = 0; i < mon; i++)
		{
			secs += (_ytab[dayspermonth][i] * SECSPERDAY); // total secs of month elapsed
		}
	}
 /*resetting the dst always to 0 as per mirko req
	tm_yday,tm_wday the orginal values will be ignored and appropriate 
	value are calculated and filled in.
	*/
	const ull_time_t  tempsecs=secs;
    date_time *temp=bschgmtime(&tempsecs);
    if(NULL!=temp)
    {
    timeptr->tm_yday=temp->tm_yday;
    timeptr->tm_wday=temp->tm_wday;
    timeptr->tm_isdst=0;
    }
  }   
	return secs;
}

/************************************************************************
 *
 * FUNCTION: ull_time_t bschmktime(date_time *timeptr)
 *
 * DESCRIPTION: Function to convert date and time values to epoch value
 *
 * PARAMETER: date_time *timeptr
 *
 * RETURNVALUE: ull_time_t
 *
 **********************************************************************/
date_time *bschgmtime_r(const ull_time_t *timeval, date_time *result)
{
	static date_time s_date_time={0};
	date_time *tp=&s_date_time;

	int64_t  seconds, minutes, hours, days, year, month;
	uint32_t dayOfWeek,yday,dim;

	if(NULL ==timeval)
	{
		return tp;// invalid value to convert
	}
	seconds = *timeval;

	/* calculate minutes */
	minutes  = seconds / 60;
	seconds -= minutes * 60;
	/* calculate hours */
	hours    = minutes / 60;
	minutes -= hours   * 60;
	/* calculate days */
	days     = hours   / 24;
	hours   -= days    * 24;

	//cout<<days<<endl;
	/* Unix time starts in 1970 on a Thursday */
	year      = 1970;
	dayOfWeek = 4;

	while(1)
	{
		bool leapYear   = LEAPYEAR(year);
		int  daysInYear = leapYear ? 366 : 365;
		if (days >= daysInYear)
		{
			dayOfWeek += leapYear ? 2 : 1;
			days      -= daysInYear;
			if (dayOfWeek >= 7)
				dayOfWeek -= 7;
			++year;
		}
		else
		{
			yday = days;
			dayOfWeek  += days;
			dayOfWeek  %= 7;


			for(month = 0; month < 12; ++month)
			{
				int  daysInMonth=0;

				/* add a day to feburary if this is a leap year */
				if (month == 1 && leapYear)
					daysInMonth=1;

				dim =_ytab[daysInMonth][month];

				if (days >= dim)
					days -= dim;

				else
					break;
			}
			break;
		}
	}


	tp->tm_sec = seconds;
	tp->tm_min = minutes;
	tp->tm_hour = hours;
	tp->tm_mday=days+1; //1-31
	tp->tm_mon=month;
	tp->tm_year=year-1900;
	tp->tm_isdst=0;
	tp->tm_wday=dayOfWeek;
	tp->tm_yday=yday;
	
	result->tm_sec = seconds;
	result->tm_min = minutes;
	result->tm_hour = hours;
	result->tm_mday=days+1; //1-31
	result->tm_mon=month;
	result->tm_year=year-1900;
	result->tm_isdst=0;
	result->tm_wday=dayOfWeek;
	result->tm_yday=yday;
	return tp;
}

