/**************************************************************************//**
 * \file       FileUtils.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef FileUtils_h
#define FileUtils_h


#include <string>


/**
 * Returns the directory component of a path.
 * Assumes unix-style forward slashes as separator.
 */
std::string dirname(::std::string path);


/**
 * Returns 'true' if 'path' is an existing directory, otherwise 'false'.
 */
bool dirExists(const ::std::string& path);


/**
 * Returns 'true' if 'path' is an existing file, otherwise 'false'.
 */
bool fileExists(const ::std::string& path);


/**
 * Creates the directory 'path'.
 * The parent directory must exist.
 * Returns 'true' if 'path' was successfully created or exists already.
 * Otherwise returns 'false'.
 */
bool makeDir(const ::std::string& path);


/**
 * Creates the directory 'path' with any parent directories.
 * Returns 'true' if 'path' was successfully created or exists already.
 * Otherwise returns 'false'.
 */
bool makePath(const ::std::string& path);


/**
 * Delete the file 'path'.
 * Return 'true' if the file was successfully deleted or did not exist before.
 * Return 'false' if the file could not be deleted.
 */
bool deleteFile(const ::std::string& path);


#endif
