/**************************************************************************//**
 * \file       TVDatabaseHandler.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "TVDatabaseHandler.h"


#define QUERY_DELETE_ALL_DATA_TV_STATION_LIST   "delete from TVStationList;"

#define FORMAT_QUERY_UPDATE_TV_SERVICE_LIST     "INSERT INTO TVStationList (channelID, presetType, channelName) VALUES ('%u', '%u', '%s');"
#define FORMAT_QUERY_DELETE_TV_TIME_STAMP       "DELETE FROM TV_Checksum;"
#define FORMAT_QUERY_UPDATE_TV_TIME_STAMP       "INSERT OR REPLACE INTO TV_Checksum (tv_timestamp) values (CURRENT_TIMESTAMP);"

#define QUERY_CREATE_TV_STATION_LIST_TABLE      "CREATE TABLE TVStationList( channelID INTEGER, presetType INTEGER, channelName CHAR(100));"
#define QUERY_CREATE_TV_CHECKSUM_TABLE          "CREATE TABLE TV_Checksum( tv_timestamp DATETIME PRIMARY KEY DEFAULT CURRENT_TIMESTAMP);"

#define QUERY_VIEW_TV_STATION_NAME              "CREATE VIEW TVStationName AS SELECT channelName AS TVStationName, channelID AS  StationID FROM TVStationList  WHERE channelID != '' ;"
#define QUERY_VIEW_TV_CHECKSUM                  "CREATE VIEW TVChecksum AS SELECT tv_timestamp FROM TV_Checksum;"

#define MAX_QUERY_LEN       1024


TVDatabaseHandler::TVDatabaseHandler()
   : SqliteDB("/var/opt/bosch/dynamic/speech/radio/speech_TV_tuner_data.db")
{
}


TVDatabaseHandler::~TVDatabaseHandler()
{
}


void TVDatabaseHandler::deleteChannelList()
{
   exec(QUERY_DELETE_ALL_DATA_TV_STATION_LIST);
}


void TVDatabaseHandler::storeChannel(const sds_tv_fi::SdsTvService::TVChannelItem& channel)
{
   char query[MAX_QUERY_LEN];
   sprintf(
      query,
      FORMAT_QUERY_UPDATE_TV_SERVICE_LIST,
      channel.getChannelID(),
      channel.getPresetType(),
      sdsa::sqlite::SqliteDB::escape(channel.getChannelName()).c_str());
   exec(query);
}


void TVDatabaseHandler::updateChecksum()
{
   exec(FORMAT_QUERY_DELETE_TV_TIME_STAMP);
   exec(FORMAT_QUERY_UPDATE_TV_TIME_STAMP);
}


void TVDatabaseHandler::setup()
{
   exec(QUERY_CREATE_TV_STATION_LIST_TABLE);
   exec(QUERY_CREATE_TV_CHECKSUM_TABLE);
   exec(QUERY_VIEW_TV_STATION_NAME);
   exec(QUERY_VIEW_TV_CHECKSUM);
}
