/**************************************************************************//**
 * \file       Sds2TvDbService.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2TvDbService.h"


Sds2TvDbService::Sds2TvDbService() : SdsTvServiceStub("tvDbServicePort")
{
}


Sds2TvDbService::~Sds2TvDbService()
{
}


void Sds2TvDbService::onStoreTVChannelNamesRequest(const ::boost::shared_ptr< sds_tv_fi::SdsTvService::StoreTVChannelNamesRequest >& request)
{
   _tvDatabaseHandler.open();
   _tvDatabaseHandler.beginTransaction();
   _tvDatabaseHandler.deleteChannelList();
   for (size_t i = 0; i < request->getChannelList().size(); ++i)
   {
      _tvDatabaseHandler.storeChannel(request->getChannelList()[i]);
   }
   _tvDatabaseHandler.updateChecksum();
   _tvDatabaseHandler.endTransaction();
   _tvDatabaseHandler.close();
   sendStoreTVChannelNamesResponse();
}
