/**************************************************************************//**
 * \file       Sds2SxmDbService.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2SxmDbService.h"


Sds2SxmDbService::Sds2SxmDbService() : SdsSxmServiceStub("SxmDbServicePort")
{
}


Sds2SxmDbService::~Sds2SxmDbService()
{
}


void Sds2SxmDbService::onStoreSXMChannelNamesRequest(const ::boost::shared_ptr< sds_sxm_fi::SdsSxmService::StoreSXMChannelNamesRequest >& request)
{
   _sxmDatabaseHandler.open();

   _sxmDatabaseHandler.beginTransaction();
   bool updateTimestamp = false;

   for (size_t i = 0; i < request->getChannelsList().size(); ++i)
   {
      const sds_sxm_fi::SdsSxmService::SXMChannelItem& channel = request->getChannelsList()[i];

      UpdateType updateType = _sxmDatabaseHandler.enGetXMStationUpdateType(channel);

      if (updateType != XM_LIST_NO_UPDATE_REQUIRED)
      {
         updateTimestamp = true;

         _sxmDatabaseHandler.vUpdateRecordForXMStationList(channel);
      }
   }
   _sxmDatabaseHandler.endTransaction();

   if (updateTimestamp)
   {
      _sxmDatabaseHandler.vUpdateTimeStamp();
   }

   sendStoreSXMChannelNamesResponse();

   _sxmDatabaseHandler.close();
}


void Sds2SxmDbService::onStoreSXMPhoneticDataRequest(const ::boost::shared_ptr< sds_sxm_fi::SdsSxmService::StoreSXMPhoneticDataRequest >& request)
{
   _sxmDatabaseHandler.open();

   _sxmDatabaseHandler.beginTransaction();
   bool updateTimestamp = false;

   for (size_t i = 0; i < request->getPhonemesList().size(); ++i)
   {
      const sds_sxm_fi::SdsSxmService::SXMPhoneticData& phoneme = request->getPhonemesList()[i];

      UpdateType updateType = _sxmDatabaseHandler.enGetXMPhoneticsUpdateType(phoneme);

      if (updateType != XM_LIST_NO_UPDATE_REQUIRED)
      {
         updateTimestamp = true;

         _sxmDatabaseHandler.vUpdateRecordForXMPhoneticList(phoneme);
      }
   }

   _sxmDatabaseHandler.endTransaction();

   if (updateTimestamp)
   {
      _sxmDatabaseHandler.vUpdateTimeStamp();
   }

   sendStoreSXMPhoneticDataResponse();

   _sxmDatabaseHandler.close();
}
