/**************************************************************************//**
 * \file       SXMDatabaseHandler.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef SXMDatabaseHandler_h
#define SXMDatabaseHandler_h


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "sds_sxm_fi/SdsSxmService.h"
#include "SqliteDB.h"


enum UpdateType
{
   XM_LIST_NO_UPDATE_REQUIRED,
   XM_LIST_UPDATE_REQUIRED,
   XM_LIST_INSERT_REQUIRED
};


class SXMDatabaseHandler : public sdsa::sqlite::SqliteDB
{
   public:
      SXMDatabaseHandler();
      virtual ~SXMDatabaseHandler();

      tVoid vDeleteAllFromXMStationList();
      tVoid vDeleteAllFromXMTimeStampTbl();

      void vUpdateRecordForXMStationList(const sds_sxm_fi::SdsSxmService::SXMChannelItem& channel);
      void vUpdateRecordForXMPhoneticList(const sds_sxm_fi::SdsSxmService::SXMPhoneticData& channelPhoneme);

      tU32 u32FindXMStationObjectId(tU16 channelNumber);
      tU32 u32FindXMStationObjectId(const ::std::string& channelName);
      UpdateType enGetXMStationUpdateType(const sds_sxm_fi::SdsSxmService::SXMChannelItem& channel);
      UpdateType enGetXMPhoneticsUpdateType(const sds_sxm_fi::SdsSxmService::SXMPhoneticData& channelPhoneme);
      tVoid vUpdateTimeStamp();
      virtual void setup();

   private:
      std::string getPhoneticsTableName(tU16 languageId);

      void setupTablesAndViews();
      void setupValidTimestamp();
      tU32 u32GetCurrentTimeStamp();
      void vInsertRecordForXMTimeStampTbl(tU32 u32Id, tU32 u32TimeStamp);
      void vUpdateRecordForXMTimeStampTbl(tU32 u32Id, tU32 u32TimeStamp);

      int selectRowAndReadInt(const ::std::string& query, int column, int defaultValue);
};


#endif
