/**************************************************************************//**
 * \file       FmRdsStationDb.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef FmRdsStationDb_h
#define FmRdsStationDb_h


#include "SqliteDB.h"
#include "sds_fm_fi/SdsFmService.h"


class FmRdsStationDb : public sdsa::sqlite::SqliteDB
{
   public:
      FmRdsStationDb();
      virtual ~FmRdsStationDb();
      void deleteStationList();
      void storeStationList(const ::std::vector<sds_fm_fi::SdsFmService::FMChannelItem>& stationList);
      void updateChecksum();

   protected:
      virtual void setup();

   private:
      void storeStation(const sds_fm_fi::SdsFmService::FMChannelItem& rdsStation);
};


#endif
