/**************************************************************************//**
 * \file       Sds2DabDbService.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2DabDbService.h"


Sds2DabDbService::Sds2DabDbService()
   : SdsDabServiceStub("DabDbServicePort")
{
}


Sds2DabDbService::~Sds2DabDbService()
{
}


void Sds2DabDbService::onStoreDabChannelNamesRequest(const ::boost::shared_ptr< sds_dab_fi::SdsDabService::StoreDabChannelNamesRequest >& request)
{
   DabDatabaseHandler db;
   db.open();
   db.beginTransaction();
   db.deleteStationList();
   db.storeStationList(request->getChannelList());
   db.updateChecksum();
   db.endTransaction();
   db.close();
   sendStoreDabChannelNamesResponse();
}
