/**************************************************************************//**
 * \file       DabDatabaseHandler.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "DabDatabaseHandler.h"
#include <stdio.h>


#define QUERY_DELETE_ALL_DATA_DAB_STATION_LIST  "delete from DABStationList;"

#define MAX_QUERY_LEN       1024 /* = 1 KB. Note: Normally 8 KB is required but for SAAL 1KB is sufficient*/

#define FORMAT_QUERY_UPDATE_DAB_SERVICE_LIST    "INSERT INTO DABStationList (Dab_id, SecComponentID, ListElementID, ServiceLabel, EnsembleLabel) VALUES ('%u', '%u', '%u', '%s', '%s');"
#define FORMAT_QUERY_DELETE_DAB_TIME_STAMP      "DELETE FROM DAB_Checksum;"
#define FORMAT_QUERY_UPDATE_DAB_TIME_STAMP      "INSERT OR REPLACE INTO DAB_Checksum (dab_timestamp) values (CURRENT_TIMESTAMP);"

#define QUERY_CREATE_DAB_STATION_LIST_TABLE     "CREATE TABLE DABStationList( Dab_id INTEGER, SecComponentID INTEGER, ListElementID INTEGER, ServiceLabel CHAR(100), EnsembleLabel CHAR(100));"
#define QUERY_CREATE_DAB_CHECKSUM_TABLE         "CREATE TABLE DAB_Checksum( dab_timestamp DATETIME PRIMARY KEY DEFAULT CURRENT_TIMESTAMP);"

#define QUERY_VIEW_DAB_SHORT_NAME               "CREATE VIEW DABShortname AS SELECT ServiceLabel AS DABShortname, Dab_id AS  StationID FROM DABStationList  WHERE ServiceLabel != '' ;"

#define QUERY_VIEW_DAB_CHECKSUM                 "CREATE VIEW DABChecksum AS SELECT dab_timestamp FROM DAB_Checksum;"


DabDatabaseHandler::DabDatabaseHandler()
   : SqliteDB("/tmp/speech/radio/DAB_tunerDB.db")
{
}


DabDatabaseHandler::~DabDatabaseHandler()
{
}


void DabDatabaseHandler::deleteStationList()
{
   exec(QUERY_DELETE_ALL_DATA_DAB_STATION_LIST);
}


void DabDatabaseHandler::storeStationList(const ::std::vector<sds_dab_fi::SdsDabService::DABChannelItem>& stationList)
{
   for (size_t i = 0; i < stationList.size(); ++i)
   {
      storeStation(stationList[i]);
   }
}


void DabDatabaseHandler::storeStation(const sds_dab_fi::SdsDabService::DABChannelItem& channel)
{
   char query[MAX_QUERY_LEN];
   snprintf(
      query,
      sizeof(query),
      FORMAT_QUERY_UPDATE_DAB_SERVICE_LIST,
      channel.getDabID(),
      channel.getSecComponentID(),
      channel.getListElementID(),
      escape(channel.getServiceLabel()).c_str(),
      escape(channel.getEnsembleLabel()).c_str());
   query[sizeof(query) - 1] = 0;    // ensure terminating zero
   exec(query);
}


void DabDatabaseHandler::updateChecksum()
{
   exec(FORMAT_QUERY_DELETE_DAB_TIME_STAMP);
   exec(FORMAT_QUERY_UPDATE_DAB_TIME_STAMP);
}


void DabDatabaseHandler::setup()
{
   exec(QUERY_CREATE_DAB_STATION_LIST_TABLE);
   exec(QUERY_CREATE_DAB_CHECKSUM_TABLE);
   exec(QUERY_VIEW_DAB_SHORT_NAME);
   exec(QUERY_VIEW_DAB_CHECKSUM);
}
