/**************************************************************************//**
 * \file       AppDatabaseHandler.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "AppDatabaseHandler.h"


#define QUERY_CREATE_APP_LIST_TABLE             "CREATE TABLE AppNames(AppIndex INTEGER PRIMARY KEY, AppID INTEGER, PageNumber INTEGER, Orthography STRING, LangID LONG INTEGER, CountryCode LONG INTEGER, LHTrans1 STRING, LHTrans2 STRING, LHTrans3 STRING, LHTrans4 STRING, LHTrans5 STRING, MaxTranscriptions INETGER);"

#define FORMAT_QUERY_UPDATE_APP_STATION_LIST    "INSERT INTO AppNames (AppIndex, AppID, PageNumber, Orthography, LangID, CountryCode, LHTrans1, LHTrans2, LHTrans3, LHTrans4, LHTrans5, MaxTranscriptions) VALUES ('%u', '%u', '%u', '%s', '%u', '%u', '%s', '%s', '%s', '%s', '%s', '%u');"

#define QUERY_CREATE_APP_CHECKSUM_TABLE         "CREATE TABLE AppChecksum(checksum INTEGER);"
#define FORMAT_QUERY_UPDATE_APP_CHECKSUM        "INSERT OR REPLACE INTO AppChecksum (checksum)  VALUES ('%u');"
#define FORMAT_QUERY_DELETE_APP_CHECKSUM        "DELETE FROM AppChecksum;"
#define QUERY_VIEW_APP_CHECKSUM                 "CREATE VIEW AppChecksumView AS SELECT checksum FROM AppChecksum;"

#define QUERY_VIEW_APP_NAME                     "CREATE VIEW AppNamesView AS SELECT AppIndex as AppIndex, AppID as AppID, PageNumber as PageNumber, Orthography as Orthography, LangID as LangID, CountryCode as CountryCode, LHTrans1 as LHTrans1, LHTrans2 as LHTrans2, LHTrans3 as LHTrans3, LHTrans4 as LHTrans4, LHTrans5 as LHTrans5, MaxTranscriptions as MaxTranscriptions FROM AppNames;"

#define QUERY_DELETE_ALL_DATA_APP_LIST          "delete from AppNames;"


#define MAX_QUERY_LEN       1024


AppDatabaseHandler::AppDatabaseHandler()
   : SqliteDB("/tmp/speech/radio/APPNAMESDB.db")
{
}


AppDatabaseHandler::~AppDatabaseHandler()
{
}


void AppDatabaseHandler::setup()
{
   exec(QUERY_CREATE_APP_LIST_TABLE);
   exec(QUERY_CREATE_APP_CHECKSUM_TABLE);
   exec(QUERY_VIEW_APP_NAME);
   exec(QUERY_VIEW_APP_CHECKSUM);
}


void AppDatabaseHandler::deleteAppList()
{
   exec(QUERY_DELETE_ALL_DATA_APP_LIST);
}


void AppDatabaseHandler::storeAppList(const sds_app_fi::SdsAppService::AppList& appList)
{
   _appNameList.clear();

   for (size_t i = 0; i < appList.getAppDetails().size(); ++i)
   {
      const sds_app_fi::SdsAppService::AppDataList& app = appList.getAppDetails()[i];
      _appNameList.push_back(app.getAppName());
      storeApp(app, i);
   }
}


void AppDatabaseHandler::storeApp(const sds_app_fi::SdsAppService::AppDataList& app, uint32 appIndex)
{
   char query[MAX_QUERY_LEN];
   //TODO: ATL5COB Uncomment this commented section and also remove the present sprintf code when Phonemes are available in correct format, so that second entry in the database would be created as explained in AIVI-65151
   /*   const ::std::vector< sds_app_fi::SdsAppService::PhonemeDataList >& phonemeList = app.getPhonemeData();
   const uint32 correctedAppIndex = (2 * appIndex) + 1;
   sprintf(
      query,
      FORMAT_QUERY_UPDATE_APP_STATION_LIST,
      correctedAppIndex,
      app.getAppID(),
      0,
      app.getAppName().c_str(),
      getLanguageCode(phonemeList, appIndex),
      getCountryCode(phonemeList, appIndex),
      getPhoneme(phonemeList, 0),
      getPhoneme(phonemeList, 1),
      getPhoneme(phonemeList, 2),
      getPhoneme(phonemeList, 3),
      getPhoneme(phonemeList, 4),
      phonemeList.size());
   exec(query);
   sprintf(
      query,
      FORMAT_QUERY_UPDATE_APP_STATION_LIST,
      correctedAppIndex + 1,
      app.getAppID(),
      0,
      app.getAppName().c_str(),
      0,
      0,
      "",
      "",
      "",
      "",
      "",
      0);
   exec(query);*/
   sprintf(
      query,
      FORMAT_QUERY_UPDATE_APP_STATION_LIST,
      appIndex + 1,
      app.getAppID(),
      0,
      app.getAppName().c_str(),
      0,
      0,
      "",
      "",
      "",
      "",
      "",
      0);
   exec(query);
}


uint32 AppDatabaseHandler::getLanguageCode(
   const ::std::vector< sds_app_fi::SdsAppService::PhonemeDataList >& phonemeList, unsigned int index) const
{
   if (phonemeList.size() && (index > 0))
   {
      return isoNameToIsoCode(getLanguageString(phonemeList[index - 1].getIsoLangCode()));
   }
   return 0;
}


uint32 AppDatabaseHandler::getCountryCode(
   const ::std::vector< sds_app_fi::SdsAppService::PhonemeDataList >& phonemeList, unsigned int index) const
{
   if (phonemeList.size() && (index > 0))
   {
      return isoNameToIsoCode(getCountryString(phonemeList[index - 1].getIsoLangCode()));
   }
   return 0;
}


::std::string AppDatabaseHandler::getLanguageString(const std::string& languageCountry) const
{
   size_t pos = languageCountry.find("_");
   if (pos != ::std::string::npos)
   {
      return languageCountry.substr(0, pos);
   }
   return "";
}


::std::string AppDatabaseHandler::getCountryString(const std::string& languageCountry) const
{
   size_t pos = languageCountry.find("_");
   if (pos != ::std::string::npos)
   {
      return languageCountry.substr(pos + 1);
   }
   return "";
}


uint32 AppDatabaseHandler::isoNameToIsoCode(const std::string& isoName) const
{
   uint32 value = 0;
   for (size_t i = 0; i < isoName.length(); i++)
   {
      value <<= 5;
      value += isoName[i] % 32;
   }
   return value;
}


const char* AppDatabaseHandler::getPhoneme(
   const ::std::vector< sds_app_fi::SdsAppService::PhonemeDataList >& phonemeList,
   size_t index) const
{
   if (phonemeList.size() > index)
   {
      return phonemeList[index].getPhoneme().c_str();
   }
   return "";
}


void AppDatabaseHandler::updateChecksum(unsigned int checksum)
{
   exec(FORMAT_QUERY_DELETE_APP_CHECKSUM);
   char szQuery[MAX_QUERY_LEN];
   sprintf(szQuery, FORMAT_QUERY_UPDATE_APP_CHECKSUM, checksum);
   exec(szQuery);
}


std::vector< ::std::string > AppDatabaseHandler::getAppNamesList()
{
   return _appNameList;
}
