/**************************************************************************//**
 * \file       AmDatabaseHandler.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "AmDatabaseHandler.h"
#include <stdio.h>


#define QUERY_CREATE_AM_STATION_LIST_TABLE      "CREATE TABLE AMStationList( object_id INTEGER, frequency INTEGER, shortstation_name CHAR(100), audioProgram INTEGER);"
#define QUERY_CREATE_AM_CHECKSUM_TABLE          "CREATE TABLE AM_Checksum( am_timestamp DATETIME PRIMARY KEY DEFAULT CURRENT_TIMESTAMP);"

#define QUERY_VIEW_AM_CHECKSUM                  "CREATE VIEW AMChecksum AS SELECT am_timestamp FROM AM_Checksum;"
#define QUERY_VIEW_AM_HD_SHORT_NAME             "CREATE VIEW AMShortname AS SELECT shortstation_name AS AMShortname, object_id AS  StationID FROM AMStationList WHERE shortstation_name != '' ;"

#define FORMAT_QUERY_UPDATE_AM_STATION_LIST     "INSERT INTO AMStationList (object_id, frequency, shortstation_name, audioProgram) VALUES ('%u', '%u', '%s', '%u');"
#define QUERY_DELETE_ALL_DATA_AM_STATION_LIST   "delete from AMStationList;"

#define FORMAT_QUERY_UPDATE_AM_TIME_STAMP       "INSERT OR REPLACE INTO AM_Checksum (am_timestamp) values (CURRENT_TIMESTAMP);"
#define FORMAT_QUERY_DELETE_AM_TIME_STAMP       "DELETE FROM AM_Checksum;"

#define MAX_QUERY_LEN       1024 /* = 1 KB. Note: Normally 8 KB is required but for SAAL 1KB is sufficient */


AmDatabaseHandler::AmDatabaseHandler()
   : SqliteDB("/tmp/speech/radio/AM_HD_tunerDB.db")
{
}


AmDatabaseHandler::~AmDatabaseHandler()
{
}


void AmDatabaseHandler::setup()
{
   exec(QUERY_CREATE_AM_STATION_LIST_TABLE);
   exec(QUERY_CREATE_AM_CHECKSUM_TABLE);
   exec(QUERY_VIEW_AM_HD_SHORT_NAME);
   exec(QUERY_VIEW_AM_CHECKSUM);
}


void AmDatabaseHandler::deleteStationList()
{
   exec(QUERY_DELETE_ALL_DATA_AM_STATION_LIST);
}


void AmDatabaseHandler::storeStationList(const ::std::vector<sds_am_fi::SdsAmService::AMChannelItem>& stationList)
{
   for (size_t i = 0; i < stationList.size(); ++i)
   {
      storeStation(stationList[i]);
   }
}


void AmDatabaseHandler::storeStation(const sds_am_fi::SdsAmService::AMChannelItem& station)
{
   char query[MAX_QUERY_LEN];
   snprintf(
      query,
      sizeof(query),
      FORMAT_QUERY_UPDATE_AM_STATION_LIST,
      station.getObjectID(),
      station.getFrequency(),
      escape(station.getStationName()).c_str(),
      station.getAudioProgram());
   query[sizeof(query) - 1] = 0;    // ensure terminating zero
   exec(query);
}


void AmDatabaseHandler::updateChecksum()
{
   exec(FORMAT_QUERY_DELETE_AM_TIME_STAMP);
   exec(FORMAT_QUERY_UPDATE_AM_TIME_STAMP);
}
