/**************************************************************************//**
 * \file       HSI_PHONE_SDS_Interface.h
 *
 * FILE :         clHSI_CMPhone.h
 * SW-COMPONENT:   HSI
 * DESCRIPTION:
 * AUTHOR:
 * COPYRIGHT:      (c) 2007 Blaupunkt Werke
 * HISTORY:
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef HSI_PHONE_SDS_Interface_h
#define HSI_PHONE_SDS_Interface_h


#include <vector>
#include <string>

#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"


enum CMPhoneMessageId
{
   CMMSG_SDS_PHONEBOOK_STATE,
   CMMSG_SDS_RESPONSE_PB_ENTRY_AVAILABILITY,
   CMMSG_SDS_REQUEST_USERWORD_AVAILABILITY,
   CMMSG_SDS_PHONE_PROFILE_AVAILABILITY
};


#define MAX_NUMBER_OF_ENTRIES_IN_PBDETAILS 5

struct tsCMPhone_UserwordEntry
{
   std::string oName;
   std::string oNumber;
   tBool bAvail;
};


typedef std::vector<tsCMPhone_UserwordEntry >   toCMPhone_UserwordList;

struct tsCMPhone_PBEntry
{
   tU32 u32Key;
   tU8 u8NumOfRows;
   tU8 u8RPD;
   tU8 u8SDSRequestNo;
};


struct tsCMPhone_ReqPBEntries
{
   tU32 u32Pos;
   std::string oPbName;
   tU8 u8TelNmbQuantity;
   tU8 u8SDSRequestNo;
};


typedef std::vector<tsCMPhone_ReqPBEntries >  toCMPhone_ReqPBEntriesList;

struct tsCMPhone_ReqPBDetails
{
   std::string oPBDetails_Name;
   tU32 u32PBDetails_Pos;
   tU8 u8NumOfItems;
   tU8 u8PBDetails_IconType[MAX_NUMBER_OF_ENTRIES_IN_PBDETAILS];
   std::string oPBDetails_TelNumber[MAX_NUMBER_OF_ENTRIES_IN_PBDETAILS];
};


struct tsCMPhone_ReqPBProfileDetails
{
   tBool bIsNewPhonebook;
   tU8 u8PhonebookHandle;
   tU8 u8DownloadState;
};


struct tsCMPhone_ReqPBEntries_ForG2PName
{
   tU32 u32PBNameID;
   std::string oPbName;
   tU32 u32PBNumberID;
   std::string oPbNumber;
};


typedef std::vector<tsCMPhone_ReqPBEntries_ForG2PName >  toCMPhone_ReqPBEntries_ForG2PNameList;


#endif
