/**************************************************************************//**
 * \file       sds2hmi_fi.h
 *
 * Helper file to avoid repetition of the defines before the actual
 * FI include.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef sds2hmi_fi_h
#define sds2hmi_fi_h


#define SDS2HMI_FI_S_IMPORT_INTERFACE_SDS2HMI_SDSFI_DBGVISITORS
#define SDS2HMI_FI_S_IMPORT_INTERFACE_SDS2HMI_SDSFI_FUNCTIONIDS
#define SDS2HMI_FI_S_IMPORT_INTERFACE_SDS2HMI_SDSFI_SERVICEINFO
#define SDS2HMI_FI_S_IMPORT_INTERFACE_SDS2HMI_SDSFI_ERRORCODES
#include "sds2hmi_fi_gen_if.h"


/**
 * Helper to simplify assignment of std::string to sds2hmi_fi_tclString.
 * The operator=() cannot be added as a free function, thus (mis-)using <<.
 * This function hides the x.c_str() conversion and the bulky enum value
 * sds2hmi_fi_tclString::FI_EN_UTF8, thus, making the resulting code much
 * more readable.
 */
inline sds2hmi_fi_tclString& operator<<(sds2hmi_fi_tclString& lhs, const std::string& rhs)
{
   (void) lhs.bSet(rhs.c_str(), sds2hmi_fi_tclString::FI_EN_UTF8);
   return lhs;
}


/**
 * Provides safe conversion of sds2hmi_fi_tclString into std::string.
 * Hides the evaluation of x.szValue == NULL.
 * A direct assignment of sds2hmi_fi_tclString to std::string would use the
 * const char* operator of sds2hmi_fi_tclString for implicit conversion,
 * which can yield NULL. This results in an invalid initialization of
 * std::string.
 */
inline std::string getString(const sds2hmi_fi_tclString& s)
{
   if (s.szValue)
   {
      return s.szValue;
   }
   else
   {
      return "";
   }
}


/**
 * Helper to simplify assignment of sds2hmi_fi_tclString to std::string.
 * The operator=() cannot be added as a free function, thus (mis-)using <<.
 * This function hides the evaluation of x.szValue == NULL.
 */
inline std::string& operator<<(std::string& lhs, const sds2hmi_fi_tclString& rhs)
{
   lhs = getString(rhs);
   return lhs;
}


#endif
