/**************************************************************************//**
 * \file       clSDS_XMLStringCreation.h
 *
 * This class holds the xml Buffer created out of provided strings.
 * It acts as an interface with the XML library. It returns a created
 * XML string
 * /remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_XMLStringCreation_h
#define clSDS_XMLStringCreation_h


#include <string>
#include <vector>
#include <map>


typedef std::map<std::string, unsigned int> ConfigItemMap;
typedef std::map<std::string, ConfigItemMap > GroupMap;


struct SDSConfigData
{
   bool phoneBookNBestMatch;
   bool audioNBestMatch;
   bool beepOnlyMode;
   bool infoAvailable;
   bool voiceBargeIn;
   bool naviAvailable;
   bool trafficServiceAvailable;
   bool unitInKm;
   bool unitInCelsius;

   struct
   {
      bool momUsed;
      bool dadUsed;
      bool parentsUsed;
      bool brotherUsed;
      bool sisterUsed;
      bool childUsed;
      bool sonUsed;
      bool daughterUsed;
      bool friendUsed;
      bool partnerUsed;
      bool wifeUsed;
      bool husbandUsed;
      bool homeUsed;
      bool officeUsed;
      bool assistantUsed;
      bool managerUsed;
      bool otherUsed;
   } phoneRelationshipFlags;
};


class clSDS_XMLStringCreation
{
   public:
      virtual ~clSDS_XMLStringCreation();
      clSDS_XMLStringCreation();
      static std::string getStaticXmlString();
      static std::string getDynamicXmlString(const SDSConfigData& cfgData);
      static void addCommandFlagsFromConfigFile(GroupMap& staticGroups);
      static void fillConfigVectorValues();

   private:
      static void addRootContextCommandFlags(GroupMap& staticGroups);
      static std::vector <std::string> _configData;
};


#endif
