/**************************************************************************//**
 * \file       clSDS_XMLDoc.h
 *
 * This class holds the xml doc created out of provided XML stream.
 * It acts as an interface with the XML library. It returns the contents
 * of the XML stream in a HMI defined tree structure (clSDS_TagContents)
 * /remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_XMLDoc_h
#define clSDS_XMLDoc_h


#include "libxml/parser.h"
#include <string>
#include <vector>


class clSDS_TagContents;


class clSDS_XMLDoc
{
   public:
      virtual ~clSDS_XMLDoc();
      clSDS_XMLDoc(std::string const& oXMLStream);
      clSDS_XMLDoc(const clSDS_XMLDoc&);
      clSDS_XMLDoc& operator=(const clSDS_XMLDoc&);
      std::vector<clSDS_TagContents> oGetElementsOfTag(std::string const& oTagName);

   private:
      void vReadChildContents(const xmlNode* oTopNode, std::vector<clSDS_TagContents>& oTagContents);
      clSDS_TagContents oReadTagContents(const xmlNode* oNode);

      xmlDocPtr _doc;
};


#endif
