/**************************************************************************//**
 * \file       clSDS_ScreenData.h
 *
 * This class works on the clSDS_XMLDoc output and retrieves useful information
 * from the created tree. It knows information about the various xml definitions
 * and also about the tags which are used.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_ScreenData_h
#define clSDS_ScreenData_h


#include "view_db/Sds_TextDB.h"


#include <string>
#include <map>
#include <vector>


class clSDS_XMLDoc;
class clSDS_ListItems;
class clSDS_TagContents;


class clSDS_ScreenData
{
   public:
      virtual ~clSDS_ScreenData();
      clSDS_ScreenData(std::string const& oXMLString);
      clSDS_ScreenData(const clSDS_ScreenData& rhs);              // copy constructor without implementation
      clSDS_ScreenData& operator =(const clSDS_ScreenData& rhs);  // assignment constructor without implementation

      std::vector<std::string> oGetList(std::vector<std::string>& oTagList);
      std::string readScreenId() const;
      std::string readTemplateId();
      std::map<std::string, std::string> oGetHeaderVariableData(tVoid);
      std::map<std::string, std::string> oGetScreenVariableData(tVoid);
      tU32 u32GetNumberOfElements() const;
      tVoid vStoreListContents(const std::vector<clSDS_ListItems>& oListContents);
      std::vector<clSDS_ListItems> oGetListItemsofView(tVoid) const;
      std::vector<tU32> oGetListOfObjectIds(tVoid) const;
      std::string getPhNumDigit() const;

      std::string getLocalIDValue(std::string rawLocalID) const;
      bool getIsSpeakableList();

   private:
      struct VariableData
      {
         std::map<std::string, std::string> oMap;
         std::string oKeyId;
         std::string oValueId;
      };

      std::string readTidTagValue(std::vector<clSDS_TagContents>& oTagContents);
      tU32 u32GetCount(std::string const& oTag) const;

      /* The below functions help in reading the contents from XML in a value key combination for a defined pattern
      Assume the below XML structure
      <Parent1><Parent2><Parent3><key>KEY1</key><value>VALUE1</value></Parent3><Parent3><key>KEY2</key><value>VALUE2</value></Parent3></Parent2></Parent1>
      Now the oGetMap function can be used to retrieve the value key pairs based on the XML format.
      ie: Once the XML definition <Parent1><Parent2><Parent3>, the key  and value definition <key>, <value> are provided, then it will return a map
      which reads , map[KEY1] = VALUE1 and map[KEY2] = VALUE2 Other below functions are its helper functions */
      std::map<std::string, std::string> oGetMap(std::vector<std::string>& oTagList, std::string const& oKeyId, std::string const& oValueId);
      std::map<std::string, std::string> oGetMap(std::vector<std::string>& oTagList, std::vector<clSDS_TagContents>& oTagContents, std::string const& oKeyId, std::string const& oValueId);
      tVoid vAddDataToMap(tU32 u32TagIndex, std::vector<std::string>& oTagList, std::vector<clSDS_TagContents>& oTagContents,  VariableData& oData);
      tVoid vAddTagDataToMap(tU32 u32TagIndex, std::vector<std::string>& oTagList, const clSDS_TagContents& oTagContent,  VariableData& oData);
      tVoid vAddToMap(std::string const& oKey, std::string const& oValue,  VariableData& oData) const;
      std::string oGetKey(std::vector<clSDS_TagContents>& oTagContent, const VariableData& oData) const;
      std::string oGetValue(std::vector<clSDS_TagContents>& oTagContent, const VariableData& oData) const;
      tVoid vGotoNextTag(tU32 u32TagIndex, std::vector<std::string>& oTagList, clSDS_TagContents& oTagContent,  VariableData& oData);
      std::vector<uint> getLocalIds(std::vector<clSDS_TagContents>& oChildrenTags) const;
      std::vector<tU32> getObjectIds(std::vector<clSDS_TagContents>& oChildrenTags) const;
      Sds_TextId getTextIDForLocalId(const std::string& localIdString) const;
      Sds_TextId getTextIDForLocalId(uint localId) const;
      std::string formatTagValue(std::string tagValue, std::vector<uint> localIDs) const;
      tBool hasLocalIDValue(std::vector<clSDS_TagContents> voChildrenTags) const;
      tVoid printListItems(const std::vector<clSDS_ListItems>& listContents) const;

      /*The below functions help in reading the values from XML for a defined pattern
      Assume the below XML structure
      <Parent1><Parent2><Parent3><data>DATA1</data></Parent3><Parent3><data>DATA2</data></Parent3></Parent2></Parent1>
      Now the oGetListofElements function can be used to retrieve the data based on the XML format.
      ie: Once the XML definition <Parent1><Parent2><Parent3><data> is provided, then it will return a list
      containing two values for this example as DATA1 and DATA2 Other below functions are its helper functions*/
      std::vector<std::string> oGetListofElements(std::vector<std::string>& oTagList, std::vector<clSDS_TagContents>& oTagContents) ;
      tVoid vAddDataToList(tU32 u32TagIndex, std::vector<std::string>& oTagList, std::vector<clSDS_TagContents>& oTagContents, std::vector<std::string>& oDataList);
      tVoid vAddTagDataToList(tU32 u32TagIndex, std::vector<std::string>& oTagList, const clSDS_TagContents& oTagContent, std::vector<std::string>& oDataList) const;
      tBool bIsLastTag(tU32 u32TagIndex, const std::vector<std::string>& oTagList) const;
      tVoid vGotoNextTag(tU32 u32TagIndex, std::vector<std::string>& oTagList, clSDS_TagContents& oTagContent, std::vector<std::string>& oDataList);
      std::string _phoneNumberDigits;
      std::string _templateId;
      clSDS_XMLDoc* _pXMLDoc;
      std::vector<clSDS_ListItems> _oListContents;
      tVoid vGetPhoneNumberDigits(std::vector<clSDS_TagContents>& oTagContents, const VariableData& oData);
};


#endif
