/**************************************************************************//**
 * \file       clSDS_QuickDialListCreator.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_QuickDialListCreator_h
#define clSDS_QuickDialListCreator_h


#include <string>
#include <vector>
#include "external/sds2hmi_fi.h"
#include "asf/core/Proxy.h"
#include "MOST_PhonBk_FIProxy.h"
#include "sds_gui_fi/SdsPhoneServiceProxy.h"
#include "application/clSDS_PhoneStatusObserver.h"


#define QUICK_DIAL_RELATIONSHIP_CATEGORY_MOM       "400"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_DAD       "401"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_PARENTS   "402"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_BROTHER   "403"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_SISTER    "404"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_CHILD     "405"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_SON       "406"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_DAUGHTER  "407"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_FRIEND    "408"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_PARTNER   "409"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_WIFE      "410"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_HUSBAND   "411"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_HOME      "412"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_OFFICE    "413"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_ASSISTANT "414"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_MANAGER   "415"
#define QUICK_DIAL_RELATIONSHIP_CATEGORY_OTHER     "416"


class clSDS_QuickDialListCreator
   : public MOST_PhonBk_FI::GetContactDetailsExtendedCallbackIF
   , public MOST_PhonBk_FI::CreateContactListCallbackIF
   , public MOST_PhonBk_FI::RequestPhoneBookListSliceExtendedCallbackIF
   , public clSDS_PhoneStatusObserver
{
   public:
      clSDS_QuickDialListCreator(::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy> phonebookProxy);

      void requestQuickDialList();

      void onCreateContactListResult(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
                                     const ::boost::shared_ptr< MOST_PhonBk_FI::CreateContactListResult >& result);
      void onCreateContactListError(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
                                    const ::boost::shared_ptr< MOST_PhonBk_FI::CreateContactListError >& error);
      void onRequestPhoneBookListSliceExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
            const ::boost::shared_ptr< MOST_PhonBk_FI::RequestPhoneBookListSliceExtendedError >& error);
      void onRequestPhoneBookListSliceExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
            const ::boost::shared_ptr< MOST_PhonBk_FI::RequestPhoneBookListSliceExtendedResult >& result);
      void onGetContactDetailsExtendedResult(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
                                             const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedResult >& result);
      void onGetContactDetailsExtendedError(const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
                                            const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedError >& error);

      //Override from PhoneStatusObservers
      void phoneStatusChanged(uint8 deviceHandle, most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus status);

   protected:
      //Method must be overrided
      virtual void onQuickDialListDataChanged() = 0;
      virtual void addQuickDialDataToList(const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedResult >& result) = 0;
      virtual void clearQuickDialData() = 0;

   protected:
      boost::shared_ptr<MOST_PhonBk_FI::MOST_PhonBk_FIProxy> _phonebookProxy;
      unsigned int _requestsCount;
      uint8 _activeDeviceHandle;
      most_BTSet_fi_types_Extended::T_e8_BTConnectionStatus _activeDeviceStatus;
};


#endif
