/**************************************************************************//**
 * \file       clSDS_MultipleDestinationsList.h
 *
 * See .cpp file for description.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_MultipleDestinationsList_h
#define clSDS_MultipleDestinationsList_h


#include <string>
#include <vector>

#include "application/clSDS_List.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"

class clSDS_NaviAmbiguitylistObserver;

class clSDS_MultipleDestinationsList
   : public clSDS_List
   , public org::bosch::cm::navigation::NavigationService::SdsGetRefinementListCallbackIF
{
   public:
      virtual ~clSDS_MultipleDestinationsList();
      clSDS_MultipleDestinationsList(::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> pNaviProxy);

      virtual void onSdsGetRefinementListError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsGetRefinementListError >& error);
      virtual void onSdsGetRefinementListResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsGetRefinementListResponse >& response);
      void vRegisterAmbiguityListObserver(clSDS_NaviAmbiguitylistObserver* oAmbiguitylistObserver);
      tVoid vRequestAmbigListToNavi(org::bosch::cm::navigation::NavigationService::SDSAddressElementType ambigousElement);
      tU32 getRefinementID(tU32 absoluteValue);
      void setHandOverList(std::vector<org::bosch::cm::navigation::NavigationService::RefinementListElement > handOverList);
   private:
      tVoid vGetListInfo(sds2hmi_fi_tcl_e8_HMI_ListType::tenType listType);
      tU32 u32GetSize();
      std::vector<clSDS_ListItems> oGetItems(tU32 u32StartIndex, tU32 u32EndIndex);
      clSDS_ListItems oGetListItem(tU32 u32Index);
      std::string oGetItem(tU32 u32Index);
      std::string oGetDistance(tU32 u32Index);
      signed char oGetDirectionFromMapping(tU32 u32Index)const;
      tBool bSelectElement(tU32 u32SelectedIndex);
      void vNotifyAmbiguitylistObserver();
      std::vector<sds2hmi_fi_tcl_HMIElementDescription> getHmiElementDescription(unsigned int index);
      enum enHeadingType
      {
         EN_HEADING_INDEX_UNKNOWN         = -1,
         EN_HEADING_INDEX_NORTH           = 0,
         EN_HEADING_INDEX_NORTH_EAST      = 1,
         EN_HEADING_INDEX_EAST            = 2,
         EN_HEADING_INDEX_SOUTH_EAST      = 3,
         EN_HEADING_INDEX_SOUTH           = 4,
         EN_HEADING_INDEX_SOUTH_WEST      = 5,
         EN_HEADING_INDEX_WEST            = 6,
         EN_HEADING_INDEX_NORTH_WEST      = 7,
      };
      std::vector<sds2hmi_fi_tcl_HMIElementDescription> _hmiElementDescriptionList;
      boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> _navigationProxy;
      std::vector<org::bosch::cm::navigation::NavigationService::RefinementListElement > _addressList;
      std::vector<clSDS_NaviAmbiguitylistObserver*> _oAmbiguityObserverlist;
};


#endif
