/**************************************************************************//**
 * \file       clSDS_MenuManager.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_MenuManager_h
#define clSDS_MenuManager_h


#include "view_db/Sds_ViewDB.h"
#include "application/clSDS_MenuControl.h"
#include "external/sds2hmi_fi.h"

class clSDS_Display;
class clSDS_ListScreen;
class clSDS_SessionControl;
class clSDS_ScreenData;
class clSDS_SdsControl;
class clSDS_SDSStatus;
class GuiService;
class PopUpService;

class clSDS_MenuManager : public clSDS_MenuControl
{
   public:
      virtual ~clSDS_MenuManager();
      clSDS_MenuManager(
         clSDS_Display* pDisplay,
         clSDS_SdsControl* pSdsControl,
         clSDS_ListScreen* pListScreen,
         clSDS_SessionControl* pSessionControl);
      tVoid vShowSDSView(clSDS_ScreenData& oScreenData, tU32 pageNumber, tU32 numberOfPages, tU8 nextPreviousOptions, unsigned int maxItemsperPage, sds2hmi_fi_tcl_e8_PopUp_UpdateType screenUpdateType);
      tVoid vCloseGUI(tBool bError = FALSE) const;
      void onElementSelected(unsigned int indexOnPage);
      void onElementSelectedHL(unsigned int indexOnPage);
      void onCursorMoved(unsigned int indexOnPage);
      void onRequestNextPage();
      void onRequestPreviousPage();
      void onSettingsRequest();
      void onHelpRequest();
      std::string getPromptId() const;
      unsigned int convertToSdsListIndex(unsigned int absoluteIndex) const;
      unsigned int getListIndex();
      void onCursorIndexChanged(unsigned int focusedIndex);
      unsigned int getDefaultFocusIndex();
      unsigned int getGrammarIdOfCommand(unsigned int listIndex) const;

   private:
      unsigned int getOverallListIndex(unsigned int indexOnPage) const;

      clSDS_Display* _pDisplay;
      clSDS_SdsControl* _pSdsControl;
      clSDS_ListScreen* _pListScreen;
      clSDS_SessionControl* _pSessionControl;
      std::string _grammarId;
      std::string _promptId;
      unsigned int _listIndex;
      unsigned int _defaultFocusIndex;
};


#endif
