/**************************************************************************//**
 * \file       clSDS_ListScreen.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "application/clSDS_ListScreen.h"

#include "SdsAdapter_Trace.h"
#define ETG_ENABLED
#include "trace_interface.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX      "SdsAdapter_"
#define ETG_I_TRACE_CHANNEL         TR_TTFIS_SAAL
#define ETG_DEFAULT_TRACE_CLASS     TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_ListScreen.cpp.trc.h"
#endif

/**************************************************************************//**
*Destructor
******************************************************************************/
clSDS_ListScreen::~clSDS_ListScreen()
{
   _pCurrentList = NULL;
   _pLastList = NULL;
   _oListMap.clear();
}


/**************************************************************************//**
*Constructor
******************************************************************************/
clSDS_ListScreen::clSDS_ListScreen()
{
   _pCurrentList = NULL;
   _pLastList = NULL;
   _oListMap.clear();
}


/**************************************************************************//**
*
******************************************************************************/
tBool clSDS_ListScreen::bIsListScreen(std::string screenId)
{
   if (_oListMap.find(screenId) != _oListMap.end())
   {
      return TRUE;
   }
   return FALSE;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_ListScreen::vSetCurrentList(std::string screenId)
{
   std::map<std::string, clSDS_List*>::const_iterator it = _oListMap.find(screenId);
   ETG_TRACE_USR4(("clSDS_ListScreen::vSetCurrentList "));
   if (it != _oListMap.end())
   {
      ETG_TRACE_USR4(("clSDS_ListScreen::vSetCurrentList if "));
      _pCurrentList = _oListMap.find(screenId)->second;
      _pLastList = _pCurrentList;
   }
   else
   {
      ETG_TRACE_USR4(("clSDS_ListScreen::vSetCurrentList else"));
      _pCurrentList = NULL;
   }
   ETG_TRACE_USR4(("clSDS_ListScreen::vSetCurrentList else _pCurrentList is %s", _pCurrentList == NULL ? "NULL" : "true"));
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_ListScreen::vAddToList(std::string screenId, clSDS_List* pHMIList)
{
   if (pHMIList == NULL)
   {
      NORMAL_M_ASSERT_ALWAYS();
      return;  //lint !e527 Unreachable code - jnd2hi: behind assertion
   }
   _oListMap[screenId] = pHMIList;
}


/**************************************************************************//**
*
******************************************************************************/
std::vector<clSDS_ListItems> clSDS_ListScreen::vGetListScreenContents(const clSDS_ScreenData& screenData, const sds2hmi_fi_tcl_e8_PopUp_UpdateType& updateType)
{
   std::vector<clSDS_ListItems> oCurrentListItems;
   if (_pCurrentList != NULL)
   {
      _pCurrentList->vProcessScreenData(screenData, updateType); /*list object will check for whatever is required*/
      stRange oRange = _pCurrentList->stGetRangeOfPage();
      oCurrentListItems = _pCurrentList->oGetItems(oRange.u32StartIndex, oRange.u32EndIndex);
   }
   return oCurrentListItems;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_ListScreen::vSetListScreenContents(std::vector<clSDS_ListItems> listItems)
{
   if (_pCurrentList != NULL)
   {
      _pCurrentList->setItems(listItems);
   }
}


/**************************************************************************//**
*
******************************************************************************/

tVoid clSDS_ListScreen::setMaxItemsPerPage(tU32 itemsPerPage)
{
   if (_pCurrentList != NULL)
   {
      _pCurrentList->setNumberOfItemsPerPage(itemsPerPage);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tU32 clSDS_ListScreen::u32GetPageNumber() const
{
   if (_pCurrentList != NULL)
   {
      return _pCurrentList->u32GetPageNumber();
   }
   return 0;
}


/**************************************************************************//**
*
******************************************************************************/
tBool clSDS_ListScreen::bSelectElement(tU32 u32SelectedIndex)
{
   if (_pCurrentList != NULL)
   {
      return _pCurrentList->bSelectElement(u32SelectedIndex);
   }
   return FALSE;
}


/**************************************************************************//**
*
******************************************************************************/
std::string clSDS_ListScreen::oGetSelectedItem(tU32 u32Index)
{
   std::string oSelectedItem;
   if (_pLastList != NULL)
   {
      oSelectedItem = _pLastList->oGetSelectedItem(u32Index);
   }
   return oSelectedItem;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_ListScreen::vResetPageNumber()
{
   if (_pCurrentList != NULL)
   {
      _pCurrentList->vResetPageNumber();
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_ListScreen::vIncrementPageNumber()
{
   if (_pCurrentList != NULL)
   {
      _pCurrentList->vIncrementPageNumber();
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_ListScreen::vDecrementPageNumber()
{
   if (_pCurrentList != NULL)
   {
      _pCurrentList->vDecrementPageNumber();
   }
}


/**************************************************************************//**
*
******************************************************************************/
tBool clSDS_ListScreen::bHasPreviousPage() const
{
   if (_pCurrentList != NULL)
   {
      return _pCurrentList->bHasPreviousPage();
   }
   return FALSE;
}


/**************************************************************************//**
*
******************************************************************************/
tBool clSDS_ListScreen::bHasNextPage() const
{
   if (_pCurrentList != NULL)
   {
      return _pCurrentList->bHasNextPage();
   }
   return FALSE;
}


/**************************************************************************//**
*
******************************************************************************/
tU8 clSDS_ListScreen::getNumOfElementsOnCurrentPage() const
{
   if (_pCurrentList != NULL)
   {
      return _pCurrentList->getNumOfElementsOnCurrentPage();
   }
   return 0;
}


std::vector<sds2hmi_fi_tcl_HMIElementDescription> clSDS_ListScreen::getHmiElementDescription(unsigned int index)
{
   std::vector<sds2hmi_fi_tcl_HMIElementDescription> hmiElementDescription;
   if (_pCurrentList != NULL)
   {
      return _pCurrentList->getHmiElementDescription(index);
   }
   return hmiElementDescription;
}


/**************************************************************************//**
*
******************************************************************************/
unsigned short int clSDS_ListScreen::getListItemsSize()
{
   if (_pCurrentList != NULL)
   {
      return static_cast<unsigned short int  >(_pCurrentList->u32GetSize());
   }
   return 0;
}


/**************************************************************************//**
*
******************************************************************************/
unsigned int clSDS_ListScreen::getMaxElementsPerPage()
{
   if (_pCurrentList != NULL)
   {
      return  _pCurrentList->getMaxElementsPerPage();
   }
   return 0;
}
